/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.userdata;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.UsedViaReflection;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.io.file.FileIOError;
import com.helger.io.file.FileOperationManager;
import com.helger.photon.core.userdata.TemporaryUserDataObject;
import com.helger.photon.core.userdata.UserDataObject;
import com.helger.scope.IScope;
import com.helger.web.scope.singleton.AbstractSessionWebSingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class UserUploadManager
extends AbstractSessionWebSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserUploadManager.class);
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, TemporaryUserDataObject> m_aMap = new CommonsHashMap();

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public UserUploadManager() {
    }

    @Nonnull
    public static UserUploadManager getInstance() {
        return (UserUploadManager)UserUploadManager.getSessionSingleton(UserUploadManager.class);
    }

    @Nonnull
    private static FileIOError _deleteUDO(@Nonnull TemporaryUserDataObject temporaryUserDataObject) {
        LOGGER.info("Deleting uploaded file " + String.valueOf(temporaryUserDataObject));
        FileIOError fileIOError = FileOperationManager.INSTANCE.deleteFile(temporaryUserDataObject.getAsFile());
        if (fileIOError.isFailure()) {
            LOGGER.error("Failed to delete UDO " + temporaryUserDataObject.getPath() + ": " + String.valueOf(fileIOError.getErrorCode()));
        }
        return fileIOError;
    }

    protected void onDestroy(@Nonnull IScope iScope) {
        for (TemporaryUserDataObject temporaryUserDataObject : this.m_aMap.values()) {
            UserUploadManager._deleteUDO(temporaryUserDataObject);
        }
        this.m_aMap.clear();
    }

    public void addUploadedFile(@Nonnull @Nonempty String string, @Nonnull TemporaryUserDataObject temporaryUserDataObject) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"FieldName");
        ValueEnforcer.notNull((Object)temporaryUserDataObject, (String)"UDO");
        this.m_aRWLock.writeLocked(() -> {
            TemporaryUserDataObject temporaryUserDataObject2 = (TemporaryUserDataObject)this.m_aMap.remove((Object)string);
            if (temporaryUserDataObject2 != null) {
                UserUploadManager._deleteUDO(temporaryUserDataObject2);
            }
            this.m_aMap.put((Object)string, (Object)temporaryUserDataObject);
        });
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, UserDataObject> confirmUploadedFiles(String ... stringArray) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        if (stringArray != null) {
            this.m_aRWLock.writeLocked(() -> this.lambda$confirmUploadedFiles$1(stringArray, (ICommonsOrderedMap)commonsLinkedHashMap));
        }
        return commonsLinkedHashMap;
    }

    @Nullable
    public UserDataObject confirmUploadedFile(@Nullable String string) {
        return (UserDataObject)this.m_aRWLock.writeLockedGet(() -> {
            TemporaryUserDataObject temporaryUserDataObject;
            if (StringHelper.isNotEmpty((String)string) && (temporaryUserDataObject = (TemporaryUserDataObject)this.m_aMap.remove((Object)string)) != null) {
                LOGGER.info("Confirmed uploaded file " + String.valueOf(temporaryUserDataObject));
                return new UserDataObject(temporaryUserDataObject.getPath());
            }
            return null;
        });
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> cancelUploadedFiles(String ... stringArray) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (ArrayHelper.isNotEmpty((Object[])stringArray)) {
            this.m_aRWLock.writeLocked(() -> this.lambda$cancelUploadedFiles$3(stringArray, (ICommonsList)commonsArrayList));
        }
        return commonsArrayList;
    }

    @Nullable
    public TemporaryUserDataObject getUploadedFile(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (TemporaryUserDataObject)this.m_aRWLock.readLockedGet(() -> (TemporaryUserDataObject)this.m_aMap.get((Object)string));
    }

    @Nonnegative
    public int getUploadedFileCount() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aMap.size());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Map", this.m_aMap).getToString();
    }

    private /* synthetic */ void lambda$cancelUploadedFiles$3(String[] stringArray, ICommonsList iCommonsList) {
        for (String string : stringArray) {
            TemporaryUserDataObject temporaryUserDataObject = (TemporaryUserDataObject)this.m_aMap.remove((Object)string);
            if (temporaryUserDataObject == null) continue;
            UserUploadManager._deleteUDO(temporaryUserDataObject);
            iCommonsList.add((Object)string);
        }
    }

    private /* synthetic */ void lambda$confirmUploadedFiles$1(String[] stringArray, ICommonsOrderedMap iCommonsOrderedMap) {
        for (String string : stringArray) {
            TemporaryUserDataObject temporaryUserDataObject = (TemporaryUserDataObject)this.m_aMap.remove((Object)string);
            if (temporaryUserDataObject == null) continue;
            LOGGER.info("Confirmed uploaded file " + String.valueOf(temporaryUserDataObject));
            iCommonsOrderedMap.put((Object)string, (Object)new UserDataObject(temporaryUserDataObject.getPath()));
        }
    }
}

