/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.userdata;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.io.relative.IFileRelativeIO;
import com.helger.io.resource.FileSystemResource;
import com.helger.photon.app.url.LinkHelper;
import com.helger.photon.core.userdata.IUserDataObject;
import com.helger.photon.io.WebFileIO;
import com.helger.url.SimpleURL;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserDataManager {
    public static final String DEFAULT_USER_DATA_PATH = "/user";
    private static final Logger LOGGER = LoggerFactory.getLogger(UserDataManager.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static String s_sUserDataPath = "/user";

    private UserDataManager() {
    }

    public static void setUserDataPath(@Nonnull @Nonempty String string) {
        ValueEnforcer.isTrue((StringHelper.getLength((CharSequence)string) >= 2 ? 1 : 0) != 0, (String)"userDataPath is too short");
        ValueEnforcer.isTrue((boolean)StringHelper.startsWith((CharSequence)string, (char)'/'), (String)"userDataPath must start with a slash");
        RW_LOCK.writeLocked(() -> {
            s_sUserDataPath = string;
        });
        LOGGER.info("Changed global user data path to '" + string + "'");
    }

    @Nonnull
    @Nonempty
    public static String getUserDataPath() {
        return (String)RW_LOCK.readLockedGet(() -> s_sUserDataPath);
    }

    @Nonnull
    @Nonempty
    public static String getContextAndUserDataPath(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        return LinkHelper.getURIWithContext((IRequestWebScopeWithoutResponse)iRequestWebScopeWithoutResponse, (String)UserDataManager.getUserDataPath());
    }

    @Nonnull
    @Nonempty
    public static String getURLPath(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull IUserDataObject iUserDataObject) {
        ValueEnforcer.notNull((Object)iUserDataObject, (String)"UDO");
        return LinkHelper.getURIWithContext((IRequestWebScopeWithoutResponse)iRequestWebScopeWithoutResponse, (String)(UserDataManager.getUserDataPath() + iUserDataObject.getPath()));
    }

    @Nonnull
    @Nonempty
    public static SimpleURL getURL(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull IUserDataObject iUserDataObject) {
        return new SimpleURL(UserDataManager.getURLPath(iRequestWebScopeWithoutResponse, iUserDataObject));
    }

    @Nonnull
    private static IFileRelativeIO _getFileIO() {
        return WebFileIO.getDataIO();
    }

    @Nonnull
    public static File getBasePathFile() {
        return UserDataManager._getFileIO().getBasePathFile();
    }

    @Nonnull
    public static FileSystemResource getResource(@Nonnull IUserDataObject iUserDataObject) {
        ValueEnforcer.notNull((Object)iUserDataObject, (String)"UDO");
        return UserDataManager._getFileIO().getResource(UserDataManager.getUserDataPath() + iUserDataObject.getPath());
    }

    @Nonnull
    public static File getFile(@Nonnull IUserDataObject iUserDataObject) {
        ValueEnforcer.notNull((Object)iUserDataObject, (String)"UDO");
        return UserDataManager._getFileIO().getFile(UserDataManager.getUserDataPath() + iUserDataObject.getPath());
    }
}

