/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.userdata;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.io.resource.FileSystemResource;
import com.helger.photon.core.userdata.UserDataManager;
import com.helger.url.SimpleURL;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.Serializable;

@MustImplementEqualsAndHashcode
public interface IUserDataObject
extends Serializable {
    @Nonnull
    @Nonempty
    public String getPath();

    public boolean isTemporary();

    @Nonnull
    @Nonempty
    default public String getAsURLPath(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        return UserDataManager.getURLPath(iRequestWebScopeWithoutResponse, this);
    }

    @Nonnull
    default public SimpleURL getAsURL(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        return UserDataManager.getURL(iRequestWebScopeWithoutResponse, this);
    }

    @Nonnull
    default public FileSystemResource getAsResource() {
        return UserDataManager.getResource(this);
    }

    @Nonnull
    default public File getAsFile() {
        return UserDataManager.getFile(this);
    }

    @Nonnull
    public IUserDataObject getCloneWithDifferentPath(@Nonnull @Nonempty String var1);
}

