/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.userdata;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.file.FilenameHelper;
import com.helger.photon.core.userdata.IUserDataObject;
import jakarta.annotation.Nonnull;

@Immutable
public abstract class AbstractUserDataObject
implements IUserDataObject {
    private final String m_sPath;
    private final boolean m_bIsTemporary;

    public AbstractUserDataObject(@Nonnull @Nonempty String string, boolean bl) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Path");
        this.m_sPath = FilenameHelper.getPathUsingUnixSeparator((String)FilenameHelper.ensurePathStartingWithSeparator((String)string));
        this.m_bIsTemporary = bl;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getPath() {
        return this.m_sPath;
    }

    @Override
    public boolean isTemporary() {
        return this.m_bIsTemporary;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractUserDataObject abstractUserDataObject = (AbstractUserDataObject)object;
        return this.m_sPath.equals(abstractUserDataObject.m_sPath);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sPath).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("path", (Object)this.m_sPath).append("isTemporary", this.m_bIsTemporary).getToString();
    }
}

