/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.uistate;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.reflection.GenericReflection;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.type.IHasObjectType;
import com.helger.base.type.ObjectType;
import com.helger.photon.core.uistate.IHasUIState;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;

public class UIStateWrapper<T extends Serializable>
implements IHasUIState {
    private final ObjectType m_aObjectType;
    private final T m_aObject;

    public UIStateWrapper(@Nonnull ObjectType objectType, @Nonnull T t) {
        ValueEnforcer.notNull((Object)objectType, (String)"ObjectType");
        ValueEnforcer.notNull(t, (String)"Object");
        this.m_aObjectType = objectType;
        this.m_aObject = t;
    }

    @Nonnull
    public ObjectType getObjectType() {
        return this.m_aObjectType;
    }

    @Nonnull
    public T getObject() {
        return this.m_aObject;
    }

    @Nullable
    public <U> U getCastedObject() {
        return (U)GenericReflection.uncheckedCast(this.m_aObject);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        UIStateWrapper uIStateWrapper = (UIStateWrapper)object;
        return this.m_aObjectType.equals((Object)uIStateWrapper.m_aObjectType) && EqualsHelper.equals(this.m_aObject, uIStateWrapper.m_aObject);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aObjectType).append(this.m_aObject).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("objectType", (Object)this.m_aObjectType).append("object", this.m_aObject).getToString();
    }

    @Nonnull
    public static <T extends Serializable> UIStateWrapper<T> create(@Nonnull ObjectType objectType, @Nonnull T t) {
        return new UIStateWrapper<T>(objectType, t);
    }

    @Nonnull
    public static <T extends Serializable & IHasObjectType> UIStateWrapper<T> create(@Nonnull T t) {
        return new UIStateWrapper<T>(((IHasObjectType)t).getObjectType(), t);
    }
}

