/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.systemmsg;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.datetime.helper.PDTFactory;
import com.helger.photon.core.systemmsg.ESystemMessageType;
import com.helger.photon.core.systemmsg.ISystemMessageData;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;

@NotThreadSafe
public class SystemMessageData
implements ISystemMessageData {
    private LocalDateTime m_aLastUpdate;
    private ESystemMessageType m_eMessageType = ESystemMessageType.DEFAULT;
    private String m_sMessage;

    public SystemMessageData() {
    }

    public SystemMessageData(@Nonnull ESystemMessageType eSystemMessageType, @Nullable String string) {
        this.internalSetMessageType(eSystemMessageType);
        this.internalSetMessage(string);
    }

    @Override
    @Nullable
    public LocalDateTime getLastUpdateDT() {
        return this.m_aLastUpdate;
    }

    @Override
    @Nonnull
    public ESystemMessageType getMessageType() {
        return this.m_eMessageType;
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.m_sMessage;
    }

    final void internalReset() {
        this.setLastUpdate(null);
        this.internalSetMessageType(ESystemMessageType.DEFAULT);
        this.internalSetMessage(null);
    }

    public final void setLastUpdate(@Nullable LocalDateTime localDateTime) {
        this.m_aLastUpdate = localDateTime;
    }

    final void internalSetMessageType(@Nonnull ESystemMessageType eSystemMessageType) {
        ValueEnforcer.notNull((Object)((Object)eSystemMessageType), (String)"Type");
        this.m_eMessageType = eSystemMessageType;
    }

    final void internalSetMessage(@Nullable String string) {
        this.m_sMessage = string;
    }

    @Nonnull
    public EChange setSystemMessage(@Nonnull ESystemMessageType eSystemMessageType, @Nullable String string) {
        ValueEnforcer.notNull((Object)((Object)eSystemMessageType), (String)"MessageType");
        if (this.m_eMessageType.equals((Object)eSystemMessageType) && EqualsHelper.equals((Object)this.m_sMessage, (Object)string)) {
            return EChange.UNCHANGED;
        }
        this.internalSetMessageType(eSystemMessageType);
        this.internalSetMessage(string);
        this.setLastUpdate(PDTFactory.getCurrentLocalDateTime());
        return EChange.CHANGED;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SystemMessageData systemMessageData = (SystemMessageData)object;
        return EqualsHelper.equals((Object)this.m_aLastUpdate, (Object)systemMessageData.m_aLastUpdate) && this.m_eMessageType.equals((Object)systemMessageData.m_eMessageType) && EqualsHelper.equals((Object)this.m_sMessage, (Object)systemMessageData.m_sMessage);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aLastUpdate).append((Object)this.m_eMessageType).append((Object)this.m_sMessage).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("LastUpdate", (Object)this.m_aLastUpdate).append("MessageType", (Enum)this.m_eMessageType).append("Message", (Object)this.m_sMessage).getToString();
    }
}

