/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.systemmsg;

import com.helger.annotation.Nonempty;
import com.helger.base.id.IHasID;
import com.helger.base.lang.EnumHelper;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.text.display.IHasDisplayText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public enum ESystemMessageType implements IHasID<String>,
IHasDisplayText
{
    INFO("i", EPhotonCoreText.SYSTEM_MESSAGE_TYPE_INFO),
    WARNING("w", EPhotonCoreText.SYSTEM_MESSAGE_TYPE_WARNING),
    ERROR("e", EPhotonCoreText.SYSTEM_MESSAGE_TYPE_ERROR),
    SUCCESS("s", EPhotonCoreText.SYSTEM_MESSAGE_TYPE_SUCCESS);

    public static final ESystemMessageType DEFAULT;
    private final String m_sID;
    private final EPhotonCoreText m_eText;

    private ESystemMessageType(String string2, EPhotonCoreText ePhotonCoreText) {
        this.m_sID = string2;
        this.m_eText = ePhotonCoreText;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_eText.getDisplayText(locale);
    }

    @Nonnull
    public static ESystemMessageType getFromIDOrDefault(@Nullable String string) {
        return (ESystemMessageType)EnumHelper.getFromIDOrDefault(ESystemMessageType.class, (Object)string, (Enum)DEFAULT);
    }

    static {
        DEFAULT = INFO;
    }
}

