/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.sysmigration;

import com.helger.annotation.Nonempty;
import com.helger.annotation.misc.ContainsSoftMigration;
import com.helger.base.string.StringParser;
import com.helger.photon.core.sysmigration.SystemMigrationResult;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.util.MicroHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;

public final class SystemMigrationResultMicroTypeConverter
implements IMicroTypeConverter<SystemMigrationResult> {
    private static final String ATTR_MIGRATION_ID = "id";
    private static final String ATTR_EXECUTION_LDT = "executionldt";
    private static final String ATTR_SUCCESS = "success";
    private static final String ELEMENT_ERROR_MSG = "errormsg";

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull SystemMigrationResult systemMigrationResult, @Nullable String string, @Nonnull @Nonempty String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_MIGRATION_ID, systemMigrationResult.getID());
        microElement.setAttributeWithConversion(ATTR_EXECUTION_LDT, (Object)systemMigrationResult.getExecutionDateTime());
        microElement.setAttribute(ATTR_SUCCESS, systemMigrationResult.isSuccess());
        if (systemMigrationResult.hasErrorMessage()) {
            microElement.addElementNS(string, ELEMENT_ERROR_MSG).addText((CharSequence)systemMigrationResult.getErrorMessage());
        }
        return microElement;
    }

    @Nonnull
    @ContainsSoftMigration
    public SystemMigrationResult convertToNative(@Nonnull IMicroElement iMicroElement) {
        Object object;
        String string = iMicroElement.getAttributeValue(ATTR_MIGRATION_ID);
        LocalDateTime localDateTime = (LocalDateTime)iMicroElement.getAttributeValueWithConversion(ATTR_EXECUTION_LDT, LocalDateTime.class);
        if (localDateTime == null) {
            object = (ZonedDateTime)iMicroElement.getAttributeValueWithConversion("executiondt", ZonedDateTime.class);
            if (object != null) {
                localDateTime = ((ZonedDateTime)object).toLocalDateTime();
            } else {
                throw new IllegalStateException("No exceution date time found!");
            }
        }
        object = iMicroElement.getAttributeValue(ATTR_SUCCESS);
        boolean bl = StringParser.parseBool((String)object);
        String string2 = MicroHelper.getChildTextContent((IMicroElement)iMicroElement, (String)ELEMENT_ERROR_MSG);
        return new SystemMigrationResult(string, localDateTime, bl, string2);
    }
}

