/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.sysmigration;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.id.IHasID;
import com.helger.base.state.ISuccessIndicator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.datetime.helper.PDTFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.time.LocalDateTime;

@Immutable
public class SystemMigrationResult
implements IHasID<String>,
ISuccessIndicator,
Serializable {
    private final String m_sMigrationID;
    private final LocalDateTime m_aExecutionDT;
    private final boolean m_bSuccess;
    private final String m_sErrorMessage;

    protected SystemMigrationResult(@Nonnull @Nonempty String string, @Nonnull LocalDateTime localDateTime, boolean bl, @Nullable String string2) {
        this.m_sMigrationID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"MigrationID");
        this.m_aExecutionDT = (LocalDateTime)ValueEnforcer.notNull((Object)localDateTime, (String)"ExecutionDT");
        this.m_bSuccess = bl;
        this.m_sErrorMessage = string2;
    }

    @Nonnull
    public String getID() {
        return this.m_sMigrationID;
    }

    @Nonnull
    public LocalDateTime getExecutionDateTime() {
        return this.m_aExecutionDT;
    }

    public boolean isSuccess() {
        return this.m_bSuccess;
    }

    public boolean isFailure() {
        return !this.m_bSuccess;
    }

    @Nullable
    public String getErrorMessage() {
        return this.m_sErrorMessage;
    }

    public boolean hasErrorMessage() {
        return StringHelper.isNotEmpty((String)this.m_sErrorMessage);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SystemMigrationResult systemMigrationResult = (SystemMigrationResult)object;
        return this.m_sMigrationID.equals(systemMigrationResult.m_sMigrationID) && this.m_aExecutionDT.equals(systemMigrationResult.m_aExecutionDT) && this.m_bSuccess == systemMigrationResult.m_bSuccess && EqualsHelper.equals((Object)this.m_sErrorMessage, (Object)systemMigrationResult.m_sErrorMessage);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sMigrationID).append((Object)this.m_aExecutionDT).append(this.m_bSuccess).append((Object)this.m_sErrorMessage).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sMigrationID).append("executionDT", (Object)this.m_aExecutionDT).append("success", this.m_bSuccess).append("errorMsg", (Object)this.m_sErrorMessage).getToString();
    }

    @Nonnull
    public static SystemMigrationResult createSuccess(@Nonnull @Nonempty String string) {
        return new SystemMigrationResult(string, PDTFactory.getCurrentLocalDateTime(), true, null);
    }

    @Nonnull
    public static SystemMigrationResult createFailure(@Nonnull @Nonempty String string, @Nonnull String string2) {
        return new SystemMigrationResult(string, PDTFactory.getCurrentLocalDateTime(), false, string2);
    }
}

