/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.sysmigration;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.state.SuccessWithValue;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.type.ObjectType;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsSet;
import com.helger.dao.DAOException;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.core.sysmigration.SystemMigrationResult;
import com.helger.photon.io.dao.AbstractPhotonSimpleDAO;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SystemMigrationManager
extends AbstractPhotonSimpleDAO {
    public static final ObjectType OT_SYSTEM_MIGRATION_RESULT = new ObjectType("systemmigrationresult");
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemMigrationManager.class);
    private static final String ELEMENT_SYSTEM_MIGRATION_RESULTS = "systemmigrationresults";
    private static final String ELEMENT_SYSTEM_MIGRATION_RESULT = "systemmigrationresult";
    private final ICommonsMap<String, ICommonsList<SystemMigrationResult>> m_aMap = new CommonsHashMap();

    public SystemMigrationManager(@Nullable String string) throws DAOException {
        super(string);
        this.initialRead();
    }

    protected EChange onRead(IMicroDocument iMicroDocument) {
        for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements(ELEMENT_SYSTEM_MIGRATION_RESULT)) {
            this.internalAdd((SystemMigrationResult)MicroTypeConverter.convertToNative((IMicroElement)iMicroElement, SystemMigrationResult.class));
        }
        return EChange.UNCHANGED;
    }

    protected IMicroDocument createWriteData() {
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.addElement(ELEMENT_SYSTEM_MIGRATION_RESULTS);
        for (List list : this.m_aMap.getSortedByKey(Comparator.naturalOrder()).values()) {
            for (SystemMigrationResult systemMigrationResult : list) {
                iMicroElement.addChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)systemMigrationResult, (String)ELEMENT_SYSTEM_MIGRATION_RESULT));
            }
        }
        return microDocument;
    }

    void internalAdd(@Nonnull SystemMigrationResult systemMigrationResult) {
        ValueEnforcer.notNull((Object)systemMigrationResult, (String)"MigrationResult");
        String string2 = systemMigrationResult.getID();
        ((ICommonsList)this.m_aMap.computeIfAbsent((Object)string2, string -> new CommonsArrayList())).add((Object)systemMigrationResult);
    }

    public void addMigrationResult(@Nonnull SystemMigrationResult systemMigrationResult) {
        ValueEnforcer.notNull((Object)systemMigrationResult, (String)"MigrationResult");
        this.m_aRWLock.writeLocked(() -> {
            this.internalAdd(systemMigrationResult);
            this.markAsChanged();
        });
        AuditHelper.onAuditCreateSuccess((ObjectType)OT_SYSTEM_MIGRATION_RESULT, (Object[])new Object[]{systemMigrationResult.getID(), systemMigrationResult.isSuccess(), systemMigrationResult.getErrorMessage()});
    }

    public void addMigrationResultSuccess(@Nonnull @Nonempty String string) {
        this.addMigrationResult(SystemMigrationResult.createSuccess(string));
    }

    public void addMigrationResultError(@Nonnull @Nonempty String string, @Nonnull String string2) {
        this.addMigrationResult(SystemMigrationResult.createFailure(string, string2));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<SystemMigrationResult> getAllMigrationResults(@Nullable String string) {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> new CommonsArrayList((Collection)this.m_aMap.get((Object)string)));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<SystemMigrationResult> getAllMigrationResultsFlattened() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        this.m_aRWLock.readLocked(() -> this.lambda$getAllMigrationResultsFlattened$3((ICommonsList)commonsArrayList));
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<SystemMigrationResult> getAllFailedMigrationResults(@Nullable String string) {
        return this.getAllMigrationResults(string).getAll(SystemMigrationResult::isFailure);
    }

    public boolean wasMigrationExecutedSuccessfully(@Nullable String string) {
        return this.getAllMigrationResults(string).containsAny(SystemMigrationResult::isSuccess);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllMigrationIDs() {
        return (ICommonsSet)this.m_aRWLock.readLockedGet(() -> this.m_aMap.copyOfKeySet());
    }

    public void performMigrationIfNecessary(@Nonnull @Nonempty String string, @Nonnull Runnable runnable) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"MigrationID");
        ValueEnforcer.notNull((Object)runnable, (String)"MigrationAction");
        if (!this.wasMigrationExecutedSuccessfully(string)) {
            try {
                LOGGER.info("Performing migration '" + string + "'");
                runnable.run();
                LOGGER.info("Finished performing migration '" + string + "'");
                this.addMigrationResultSuccess(string);
            }
            catch (RuntimeException runtimeException) {
                LOGGER.error("Error execution system migration '" + string + "'", (Throwable)runtimeException);
                this.addMigrationResultError(string, String.valueOf(runtimeException.getClass()) + ": " + runtimeException.getMessage());
            }
        }
    }

    public void performMigrationIfNecessary(@Nonnull @Nonempty String string, @Nonnull Supplier<SuccessWithValue<String>> supplier) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"MigrationID");
        ValueEnforcer.notNull(supplier, (String)"MigrationAction");
        if (!this.wasMigrationExecutedSuccessfully(string)) {
            try {
                LOGGER.info("Performing migration '" + string + "'");
                SuccessWithValue<String> successWithValue = supplier.get();
                LOGGER.info("Finished performing migration '" + string + "' with status " + (successWithValue.isSuccess() ? "success" : "error"));
                if (successWithValue.isSuccess()) {
                    this.addMigrationResultSuccess(string);
                } else {
                    this.addMigrationResultError(string, (String)successWithValue.get());
                }
            }
            catch (RuntimeException runtimeException) {
                LOGGER.error("Error execution system migration '" + string + "'", (Throwable)runtimeException);
                this.addMigrationResultError(string, String.valueOf(runtimeException.getClass()) + ": " + runtimeException.getMessage());
            }
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("map", this.m_aMap).getToString();
    }

    private /* synthetic */ void lambda$getAllMigrationResultsFlattened$3(ICommonsList iCommonsList) {
        for (ICommonsList iCommonsList2 : this.m_aMap.values()) {
            iCommonsList.addAll((Collection)iCommonsList2);
        }
    }
}

