/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.smtp;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.iface.IHasSize;
import com.helger.base.state.EChange;
import com.helger.base.state.IChangeIndicator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.type.ObjectType;
import com.helger.collection.CollectionFind;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsSet;
import com.helger.dao.DAOException;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.core.smtp.NamedSMTPSettings;
import com.helger.photon.io.dao.AbstractPhotonSimpleDAO;
import com.helger.smtp.CSMTP;
import com.helger.smtp.settings.ISMTPSettings;
import com.helger.smtp.settings.SMTPSettings;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Comparator;

@ThreadSafe
public class NamedSMTPSettingsManager
extends AbstractPhotonSimpleDAO
implements IHasSize {
    private static final String ELEMENT_ROOT = "namedsmtpsettingslist";
    private static final String ELEMENT_ITEM = "namedsmtpsettings";
    private static boolean s_bCreateDefaults = true;
    private final ICommonsMap<String, NamedSMTPSettings> m_aMap = new CommonsHashMap();

    public static boolean isCreateDefaults() {
        return RW_LOCK.readLockedBoolean(() -> s_bCreateDefaults);
    }

    public static void setCreateDefaults(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bCreateDefaults = bl;
        });
    }

    public NamedSMTPSettingsManager(@Nonnull @Nonempty String string) throws DAOException {
        super(string);
        this.initialRead();
    }

    public boolean isReloadable() {
        return true;
    }

    public void reload() throws DAOException {
        this.m_aRWLock.writeLockedThrowing(() -> {
            this.m_aMap.clear();
            this.initialRead();
        });
    }

    @Nonnull
    protected EChange onInit() {
        if (!NamedSMTPSettingsManager.isCreateDefaults()) {
            return EChange.UNCHANGED;
        }
        this._addItem(new NamedSMTPSettings("default", "default", (ISMTPSettings)new SMTPSettings("localhost", 25, null, null, CSMTP.CHARSET_SMTP_OBJ, false)));
        return EChange.CHANGED;
    }

    @Nonnull
    protected EChange onRead(@Nonnull IMicroDocument iMicroDocument) {
        for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements(ELEMENT_ITEM)) {
            this._addItem((NamedSMTPSettings)MicroTypeConverter.convertToNative((IMicroElement)iMicroElement, NamedSMTPSettings.class));
        }
        return EChange.UNCHANGED;
    }

    @Nonnull
    protected IMicroDocument createWriteData() {
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.addElement(ELEMENT_ROOT);
        for (NamedSMTPSettings namedSMTPSettings : this.m_aMap.getSortedByKey(Comparator.naturalOrder()).values()) {
            iMicroElement.addChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)namedSMTPSettings, (String)ELEMENT_ITEM));
        }
        return microDocument;
    }

    private void _addItem(@Nonnull NamedSMTPSettings namedSMTPSettings) {
        String string = namedSMTPSettings.getID();
        if (this.m_aMap.containsKey((Object)string)) {
            throw new IllegalArgumentException("NamedSMTPSettings ID " + string + " is already in use!");
        }
        this.m_aMap.put((Object)string, (Object)namedSMTPSettings);
    }

    @Nonnegative
    public int size() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aMap.size());
    }

    public boolean isEmpty() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aMap.isEmpty());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, NamedSMTPSettings> getAllSettings() {
        return (ICommonsMap)this.m_aRWLock.readLockedGet(() -> this.m_aMap.getClone());
    }

    public boolean containsSettings(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aMap.containsKey((Object)string));
    }

    @Nullable
    public NamedSMTPSettings getSettings(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (NamedSMTPSettings)this.m_aRWLock.readLockedGet(() -> (NamedSMTPSettings)this.m_aMap.get((Object)string));
    }

    @Nullable
    public NamedSMTPSettings getDefaultSettings() {
        return this.getSettings("default");
    }

    @Nullable
    public ISMTPSettings getDefaultSMTPSettings() {
        NamedSMTPSettings namedSMTPSettings = this.getDefaultSettings();
        return namedSMTPSettings == null ? null : namedSMTPSettings.getSMTPSettings();
    }

    @Nullable
    public NamedSMTPSettings getSettingsOfName(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (NamedSMTPSettings)this.m_aRWLock.readLockedGet(() -> (NamedSMTPSettings)CollectionFind.findFirst((Iterable)this.m_aMap.values(), namedSMTPSettings -> namedSMTPSettings.getName().equals(string)));
    }

    @Nonnull
    public NamedSMTPSettings addSettings(@Nonnull @Nonempty String string, @Nonnull ISMTPSettings iSMTPSettings) {
        NamedSMTPSettings namedSMTPSettings = new NamedSMTPSettings(string, iSMTPSettings);
        this.m_aRWLock.writeLocked(() -> {
            this._addItem(namedSMTPSettings);
            this.markAsChanged();
        });
        AuditHelper.onAuditCreateSuccess((ObjectType)NamedSMTPSettings.OT, (Object[])new Object[]{namedSMTPSettings.getID(), namedSMTPSettings.getName(), iSMTPSettings.getHostName(), iSMTPSettings.getPort(), iSMTPSettings.getCharsetName(), iSMTPSettings.isSSLEnabled(), iSMTPSettings.isSTARTTLSEnabled(), iSMTPSettings.getConnectionTimeoutMilliSecs(), iSMTPSettings.getTimeoutMilliSecs()});
        return namedSMTPSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public EChange updateSettings(@Nullable String string, @Nonnull @Nonempty String string2, @Nonnull ISMTPSettings iSMTPSettings) {
        NamedSMTPSettings namedSMTPSettings = this.getSettings(string);
        if (namedSMTPSettings == null) {
            AuditHelper.onAuditModifyFailure((ObjectType)NamedSMTPSettings.OT, (String)string, (Object[])new Object[]{"no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.UNCHANGED;
            eChange = eChange.or((IChangeIndicator)namedSMTPSettings.setName(string2));
            eChange = eChange.or((IChangeIndicator)namedSMTPSettings.setSMTPSettings(iSMTPSettings));
            if (eChange.isUnchanged()) {
                EChange eChange2 = EChange.UNCHANGED;
                return eChange2;
            }
            this.markAsChanged();
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)NamedSMTPSettings.OT, (String)namedSMTPSettings.getID(), (Object[])new Object[]{namedSMTPSettings.getName(), iSMTPSettings.getHostName(), iSMTPSettings.getPort(), iSMTPSettings.getCharsetName(), iSMTPSettings.isSSLEnabled(), iSMTPSettings.isSTARTTLSEnabled(), iSMTPSettings.getConnectionTimeoutMilliSecs(), iSMTPSettings.getTimeoutMilliSecs()});
        return EChange.CHANGED;
    }

    @Nullable
    public EChange removeSettings(@Nullable String string) {
        return (EChange)this.m_aRWLock.writeLockedGet(() -> {
            EChange eChange = EChange.valueOf((this.m_aMap.remove((Object)string) != null ? 1 : 0) != 0);
            if (eChange.isChanged()) {
                this.markAsChanged();
                AuditHelper.onAuditDeleteSuccess((ObjectType)NamedSMTPSettings.OT, (Object[])new Object[]{string});
            } else {
                AuditHelper.onAuditDeleteFailure((ObjectType)NamedSMTPSettings.OT, (Object[])new Object[]{string, "no-such-id"});
            }
            return eChange;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public EChange removeAllSettings() {
        ICommonsSet iCommonsSet = (ICommonsSet)this.m_aRWLock.readLockedGet(() -> this.m_aMap.copyOfKeySet());
        EChange eChange = EChange.UNCHANGED;
        this.beginWithoutAutoSave();
        try {
            for (String string : iCommonsSet) {
                eChange = eChange.or((IChangeIndicator)this.removeSettings(string));
            }
        }
        finally {
            this.endWithoutAutoSave();
        }
        return eChange;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Map", this.m_aMap).getToString();
    }
}

