/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.smtp;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.type.ITypedObject;
import com.helger.base.type.ObjectType;
import com.helger.smtp.settings.ISMTPSettings;
import jakarta.annotation.Nonnull;
import java.io.Serializable;

public class NamedSMTPSettings
implements ITypedObject<String>,
Serializable {
    public static final ObjectType OT = new ObjectType("named-smtp-settings");
    private final String m_sID;
    private String m_sName;
    private ISMTPSettings m_aSMTPSettings;

    public NamedSMTPSettings(@Nonnull @Nonempty String string, @Nonnull ISMTPSettings iSMTPSettings) {
        this(GlobalIDFactory.getNewPersistentStringID(), string, iSMTPSettings);
    }

    NamedSMTPSettings(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull ISMTPSettings iSMTPSettings) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
        this.m_sID = string;
        this.setName(string2);
        this.setSMTPSettings(iSMTPSettings);
    }

    @Nonnull
    public ObjectType getObjectType() {
        return OT;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Nonnull
    public EChange setName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        if (string.equals(this.m_sName)) {
            return EChange.UNCHANGED;
        }
        this.m_sName = string;
        return EChange.CHANGED;
    }

    @Nonnull
    public ISMTPSettings getSMTPSettings() {
        return this.m_aSMTPSettings;
    }

    @Nonnull
    public EChange setSMTPSettings(@Nonnull ISMTPSettings iSMTPSettings) {
        ValueEnforcer.notNull((Object)iSMTPSettings, (String)"SMTPSettings");
        if (iSMTPSettings.equals((Object)this.m_aSMTPSettings)) {
            return EChange.UNCHANGED;
        }
        this.m_aSMTPSettings = iSMTPSettings;
        return EChange.CHANGED;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        NamedSMTPSettings namedSMTPSettings = (NamedSMTPSettings)object;
        return this.m_sID.equals(namedSMTPSettings.m_sID);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).append("name", (Object)this.m_sName).append("SMTPsettings", (Object)this.m_aSMTPSettings).getToString();
    }
}

