/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.smtp;

import com.helger.annotation.concurrent.ELockType;
import com.helger.annotation.concurrent.MustBeLocked;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.exception.InitializationException;
import com.helger.base.state.EChange;
import com.helger.collection.commons.ICommonsList;
import com.helger.dao.DAOException;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.io.dao.AbstractPhotonSimpleDAO;
import com.helger.smtp.failed.FailedMailData;
import com.helger.smtp.failed.FailedMailQueue;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

@ThreadSafe
public class FailedMailQueueWithDAO
extends FailedMailQueue {
    private FMQDAO m_aDAO;

    public FailedMailQueueWithDAO(@Nullable String string) {
        try {
            this.m_aDAO = new FMQDAO(string);
            this.m_aDAO.myInitialRead();
        }
        catch (DAOException dAOException) {
            throw new InitializationException("Failed to init FailedMailQueueWithDAO with filename '" + string + "'", (Throwable)dAOException);
        }
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeUTF((String)this.m_aDAO.getFilenameProvider().get());
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        String string = objectInputStream.readUTF();
        try {
            this.m_aDAO = new FMQDAO(string);
            this.m_aDAO.myInitialRead();
        }
        catch (DAOException dAOException) {
            throw new InitializationException("Failed to init FailedMailQueueWithDAO with filename '" + string + "'", (Throwable)dAOException);
        }
    }

    private void _markAsChanged() {
        this.m_aRWLock.writeLocked(this.m_aDAO::myMarkChanged);
    }

    public void add(@Nonnull FailedMailData failedMailData) {
        this.add(failedMailData, true);
    }

    public void add(@Nonnull FailedMailData failedMailData, boolean bl) {
        super.add(failedMailData);
        this._markAsChanged();
        if (bl) {
            AuditHelper.onAuditExecuteSuccess((String)"failedmail-add", (Object[])new Object[]{failedMailData});
        }
    }

    @Nullable
    public FailedMailData remove(@Nullable String string) {
        FailedMailData failedMailData = super.remove(string);
        if (failedMailData != null) {
            this._markAsChanged();
            AuditHelper.onAuditExecuteSuccess((String)"failedmail-remove", (Object[])new Object[]{string});
        } else {
            AuditHelper.onAuditExecuteFailure((String)"failedmail-remove", (Object[])new Object[]{string});
        }
        return failedMailData;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<FailedMailData> removeAll() {
        ICommonsList iCommonsList = super.removeAll();
        if (!iCommonsList.isEmpty()) {
            this._markAsChanged();
            AuditHelper.onAuditExecuteSuccess((String)"failedmail-remove-all", (Object[])new Object[]{iCommonsList.size()});
        }
        return iCommonsList;
    }

    private final class FMQDAO
    extends AbstractPhotonSimpleDAO {
        private static final String ELEMENT_FAILEDMAILS = "failedmails";
        private static final String ELEMENT_FAILEDMAILDATA = "failedmaildata";

        public FMQDAO(String string) {
            super(string);
        }

        @MustBeLocked(value=ELockType.WRITE)
        void myInitialRead() throws DAOException {
            this.initialRead();
        }

        @MustBeLocked(value=ELockType.WRITE)
        void myMarkChanged() {
            super.markAsChanged();
        }

        @Nonnull
        protected EChange onRead(@Nonnull IMicroDocument iMicroDocument) {
            for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements(ELEMENT_FAILEDMAILDATA)) {
                FailedMailData failedMailData = (FailedMailData)MicroTypeConverter.convertToNative((IMicroElement)iMicroElement, FailedMailData.class);
                if (failedMailData == null) continue;
                FailedMailQueueWithDAO.this.add(failedMailData, false);
            }
            return EChange.UNCHANGED;
        }

        @Nonnull
        protected IMicroDocument createWriteData() {
            MicroDocument microDocument = new MicroDocument();
            IMicroElement iMicroElement = microDocument.addElement(ELEMENT_FAILEDMAILS);
            for (FailedMailData failedMailData : FailedMailQueueWithDAO.this.getAllFailedMails()) {
                iMicroElement.addChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)failedMailData, (String)ELEMENT_FAILEDMAILDATA));
            }
            return microDocument;
        }
    }
}

