/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.servlet;

import com.helger.annotation.Nonempty;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.exception.InitializationException;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.base.id.factory.ILongIDFactory;
import com.helger.base.lang.ClassPathHelper;
import com.helger.base.name.IHasDisplayName;
import com.helger.base.pool.ObjectPool;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringParser;
import com.helger.base.system.EJVMVendor;
import com.helger.base.system.SystemHelper;
import com.helger.base.system.SystemProperties;
import com.helger.base.thirdparty.IThirdPartyModule;
import com.helger.base.thirdparty.ThirdPartyModuleRegistry;
import com.helger.base.timing.StopWatch;
import com.helger.base.url.URLHelper;
import com.helger.collection.commons.CommonsTreeMap;
import com.helger.collection.helper.CollectionSort;
import com.helger.css.propertyvalue.CSSValue;
import com.helger.dao.AbstractDAO;
import com.helger.datetime.helper.PDTFactory;
import com.helger.datetime.util.PDTIOHelper;
import com.helger.datetime.web.PDTWebDateHelper;
import com.helger.html.hc.config.HCSettings;
import com.helger.photon.ajax.GlobalAjaxInvoker;
import com.helger.photon.ajax.IAjaxRegistry;
import com.helger.photon.api.GlobalAPIInvoker;
import com.helger.photon.api.IAPIRegistry;
import com.helger.photon.app.resource.WebSiteResourceCache;
import com.helger.photon.core.CPhotonVersion;
import com.helger.photon.core.PhotonCoreInit;
import com.helger.photon.core.locale.GlobalLocaleManager;
import com.helger.photon.core.locale.ILocaleManager;
import com.helger.photon.core.smtp.AuditingEmailDataTransportListener;
import com.helger.photon.io.PhotonWorkerPool;
import com.helger.photon.io.WebFileIO;
import com.helger.photon.io.WebIOLongIDFactory;
import com.helger.photon.security.password.GlobalPasswordSettings;
import com.helger.photon.security.password.constraint.IPasswordConstraint;
import com.helger.photon.security.password.constraint.IPasswordConstraintList;
import com.helger.photon.security.password.constraint.PasswordConstraintList;
import com.helger.photon.security.password.constraint.PasswordConstraintMinLength;
import com.helger.servlet.ServletContextPathHolder;
import com.helger.servlet.ServletHelper;
import com.helger.servlet.StaticServerInfo;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.smtp.EmailGlobalSettings;
import com.helger.smtp.listener.IEmailDataTransportListener;
import com.helger.smtp.transport.listener.LoggingConnectionListener;
import com.helger.text.compare.ComparatorHelper;
import com.helger.text.locale.LocaleCache;
import com.helger.text.locale.country.CountryCache;
import com.helger.text.locale.language.LanguageCache;
import com.helger.typeconvert.impl.TypeConverter;
import com.helger.web.scope.mgr.WebScopeManager;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.util.statistics.StatisticsExporter;
import com.helger.xservlet.filter.XServletFilterConsistency;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.mail.event.ConnectionListener;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.io.File;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppListener
implements ServletContextListener,
HttpSessionListener {
    public static final String DEFAULT_INIT_PARAMETER_DEBUG = "debug";
    public static final String DEFAULT_INIT_PARAMETER_PRODUCTION = "production";
    public static final String INIT_PARAMETER_DATA_PATH = "dataPath";
    public static final String INIT_PARAMETER_NO_STARTUP_INFO = "noStartupInfo";
    public static final String INIT_PARAMETER_SERVER_URL = "serverUrl";
    public static final String INIT_PARAMETER_SERVER_URL_PRODUCTION = "serverUrlProduction";
    public static final String INIT_PARAMETER_NO_CHECK_FILE_ACCESS = "noCheckFileAccess";
    public static final String ID_FILENAME = "persistent_id.dat";
    public static final int DEFAULT_PASSWORD_MIN_LENGTH = 8;
    public static final boolean DEFAULT_HANDLE_STATISTICS_ON_END = true;
    private static final Logger LOGGER;
    private static final AtomicBoolean ONLY_ONE_INSTANCE_ALLOWED;
    private static final AtomicBoolean INITED;
    private LocalDateTime m_aInitializationStartDT;
    private LocalDateTime m_aInitializationEndDT;
    private boolean m_bHandleStatisticsOnEnd = true;

    public static void setOnlyOneInstanceAllowed(boolean bl) {
        ONLY_ONE_INSTANCE_ALLOWED.set(bl);
    }

    public static boolean isOnlyOneInstanceAllowed() {
        return ONLY_ONE_INSTANCE_ALLOWED.get();
    }

    protected static final void logLogo() {
        LOGGER.info("       _                 _              ");
        LOGGER.info(" _ __ | |__         ___ | |_ ___  _ __  ");
        LOGGER.info("| '_ \\| '_ \\ _____ / _ \\| __/ _ \\| '_ \\ ");
        LOGGER.info("| |_) | | | |_____| (_) | || (_) | | | |");
        LOGGER.info("| .__/|_| |_|      \\___/ \\__\\___/|_| |_|");
        String string = StringHelper.getRepeated((char)' ', (int)Math.max(20 - CPhotonVersion.BUILD_VERSION.length(), 0));
        LOGGER.info("|_|                " + string + "v" + CPhotonVersion.BUILD_VERSION);
    }

    protected final void logServerInfo(@Nonnull ServletContext servletContext) {
        LOGGER.info("Java " + SystemProperties.getJavaVersion() + " running '" + servletContext.getServletContextName() + "' on " + servletContext.getServerInfo() + " with " + Runtime.getRuntime().maxMemory() / 0x100000L + "MB max RAM and Servlet API " + servletContext.getMajorVersion() + "." + servletContext.getMinorVersion());
        EJVMVendor eJVMVendor = EJVMVendor.getCurrentVendor();
        if (eJVMVendor.isSun() && eJVMVendor != EJVMVendor.SUN_SERVER) {
            LOGGER.warn("Consider using the Sun Server Runtime by specifiying '-server' on the commandline!");
        }
        if (this.getClass().desiredAssertionStatus()) {
            LOGGER.warn("Java assertions are enabled - this should be disabled in production!");
        }
    }

    protected static final void logClassPath() {
        if (GlobalDebug.isDebugMode()) {
            List list = ClassPathHelper.getAllClassPathEntries();
            Collections.sort(list);
            LOGGER.info("Class path [" + list.size() + " elements]:");
            for (String string : list) {
                LOGGER.info("  " + string);
            }
        }
    }

    protected static final void logInitParameters(@Nonnull ServletContext servletContext) {
        CommonsTreeMap commonsTreeMap = new CommonsTreeMap();
        Enumeration enumeration = servletContext.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = servletContext.getInitParameter(string);
            commonsTreeMap.put((Object)string, object);
        }
        if (commonsTreeMap.isEmpty()) {
            LOGGER.info("No servlet context init-parameters present");
        } else {
            LOGGER.info("Servlet context init-parameters:");
            for (Object object : commonsTreeMap.entrySet()) {
                LOGGER.info("  " + (String)object.getKey() + "=" + (String)object.getValue());
            }
        }
    }

    protected static final void logThirdpartyModules() {
        Set set = ThirdPartyModuleRegistry.getInstance().getAllRegisteredThirdPartyModules();
        if (!set.isEmpty()) {
            LOGGER.info("Using the following third party modules:");
            for (IThirdPartyModule iThirdPartyModule : CollectionSort.getSorted((Collection)set, (Comparator)ComparatorHelper.getComparatorCollating(IHasDisplayName::getDisplayName, (Locale)SystemHelper.getSystemLocale()))) {
                if (iThirdPartyModule.isOptional()) continue;
                StringBuilder stringBuilder = new StringBuilder("  ").append(iThirdPartyModule.getDisplayName());
                if (iThirdPartyModule.getVersion() != null) {
                    stringBuilder.append(' ').append(iThirdPartyModule.getVersion().getAsString(true));
                }
                stringBuilder.append(" licensed under ").append(iThirdPartyModule.getLicense().getDisplayName());
                if (iThirdPartyModule.getLicense().getVersion() != null) {
                    stringBuilder.append(' ').append(iThirdPartyModule.getLicense().getVersion().getAsString());
                }
                LOGGER.info(stringBuilder.toString());
            }
        }
    }

    protected static final void logJMX() {
        if (SystemProperties.getPropertyValueOrNull((String)"com.sun.management.jmxremote") != null) {
            String string = SystemProperties.getPropertyValueOrNull((String)"com.sun.management.jmxremote.port");
            String string2 = SystemProperties.getPropertyValueOrNull((String)"com.sun.management.jmxremote.ssl");
            String string3 = SystemProperties.getPropertyValueOrNull((String)"com.sun.management.jmxremote.authenticate");
            String string4 = SystemProperties.getPropertyValueOrNull((String)"com.sun.management.jmxremote.password.file");
            String string5 = SystemProperties.getPropertyValueOrNull((String)"com.sun.management.jmxremote.access.file");
            LOGGER.info("Remote JMX is enabled!");
            if (string != null) {
                LOGGER.info("  Port=" + string);
            }
            if (string2 != null) {
                LOGGER.info("  SSL enabled=" + string2);
            }
            if (string3 != null) {
                LOGGER.info("  Authenticate=" + string3);
            }
            if (string4 != null) {
                LOGGER.info("  Password file=" + string4);
            }
            if (string5 != null) {
                LOGGER.info("  Access file=" + string5);
            }
        }
    }

    @OverrideOnDemand
    protected void logStartupInfo(@Nonnull ServletContext servletContext) {
        WebAppListener.logLogo();
        this.logServerInfo(servletContext);
        WebAppListener.logClassPath();
        WebAppListener.logInitParameters(servletContext);
        WebAppListener.logThirdpartyModules();
        WebAppListener.logJMX();
    }

    @OverrideOnDemand
    protected void onTheVeryBeginning(@Nonnull ServletContext servletContext) {
    }

    @OverrideOnDemand
    protected void beforeContextInitialized(@Nonnull ServletContext servletContext) {
    }

    @OverrideOnDemand
    protected void afterContextInitialized(@Nonnull ServletContext servletContext) {
    }

    @Nullable
    @OverrideOnDemand
    protected String getInitParameterDebug(@Nonnull ServletContext servletContext) {
        return servletContext.getInitParameter(DEFAULT_INIT_PARAMETER_DEBUG);
    }

    @Nullable
    @OverrideOnDemand
    protected String getInitParameterProduction(@Nonnull ServletContext servletContext) {
        return servletContext.getInitParameter(DEFAULT_INIT_PARAMETER_PRODUCTION);
    }

    @Nullable
    @OverrideOnDemand
    protected String getInitParameterNoStartupInfo(@Nonnull ServletContext servletContext) {
        return servletContext.getInitParameter(INIT_PARAMETER_NO_STARTUP_INFO);
    }

    @Nullable
    @OverrideOnDemand
    protected String getInitParameterServerURL(@Nonnull ServletContext servletContext, boolean bl) {
        String string = bl ? INIT_PARAMETER_SERVER_URL_PRODUCTION : INIT_PARAMETER_SERVER_URL;
        return servletContext.getInitParameter(string);
    }

    @Nonnull
    @Nonempty
    protected String getServletContextPath(@Nonnull ServletContext servletContext) throws IllegalStateException {
        return ServletHelper.getServletContextBasePath((ServletContext)servletContext);
    }

    @Nonnull
    @Nonempty
    @OverrideOnDemand
    protected String getDataPath(@Nonnull ServletContext servletContext) {
        String string = servletContext.getInitParameter(INIT_PARAMETER_DATA_PATH);
        if (StringHelper.isEmpty((String)string) && StringHelper.isNotEmpty((String)(string = servletContext.getInitParameter("storagePath")))) {
            LOGGER.error("You are using the old 'storagePath' parameter. Please use 'dataPath' instead!");
        }
        if (StringHelper.isEmpty((String)string)) {
            string = this.getServletContextPath(servletContext);
            if (GlobalDebug.isDebugMode()) {
                LOGGER.info("No servlet context init-parameter 'dataPath' found! Defaulting to servlet context path '" + string + "'");
            }
        }
        return string;
    }

    @OverrideOnDemand
    protected boolean shouldCheckFileAccess(@Nonnull ServletContext servletContext) {
        return !StringParser.parseBool((String)servletContext.getInitParameter(INIT_PARAMETER_NO_CHECK_FILE_ACCESS));
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected void initPaths(@Nonnull ServletContext servletContext) {
        String string = this.getServletContextPath(servletContext);
        String string2 = this.getDataPath(servletContext);
        if (StringHelper.isEmpty((String)string2)) {
            throw new InitializationException("No data path was provided!");
        }
        File file = new File(string2).getAbsoluteFile();
        boolean bl = this.shouldCheckFileAccess(servletContext);
        WebFileIO.initPaths((File)file, (String)string, (boolean)bl);
    }

    @OverrideOnDemand
    protected void initGlobalIDFactory() {
        GlobalIDFactory.setPersistentLongIDFactory((ILongIDFactory)new WebIOLongIDFactory(ID_FILENAME));
        GlobalIDFactory.setPersistentIntIDFactory(() -> (int)GlobalIDFactory.getNewPersistentLongID());
    }

    protected static final void initDefaultGlobalSettings() {
        WebScopeManager.setSessionPassivationAllowed((boolean)false);
        GlobalPasswordSettings.setPasswordConstraintList((IPasswordConstraintList)new PasswordConstraintList(new IPasswordConstraint[]{new PasswordConstraintMinLength(8)}));
        EmailGlobalSettings.addEmailDataTransportListener((IEmailDataTransportListener)new AuditingEmailDataTransportListener());
        if (GlobalDebug.isDebugMode()) {
            EmailGlobalSettings.addConnectionListener((ConnectionListener)new LoggingConnectionListener());
        } else {
            HCSettings.getMutableConversionSettings().setToOptimized();
            CSSValue.setConsistencyChecksEnabled((boolean)false);
        }
    }

    @OverrideOnDemand
    protected void initGlobalSettings() {
    }

    @OverrideOnDemand
    protected void initLocales(@Nonnull ILocaleManager iLocaleManager) {
    }

    @OverrideOnDemand
    protected void initMenu() {
    }

    @OverrideOnDemand
    protected void initAjax(@Nonnull IAjaxRegistry iAjaxRegistry) {
    }

    @OverrideOnDemand
    protected void initAPI(@Nonnull IAPIRegistry iAPIRegistry) {
    }

    @OverrideOnDemand
    protected void initSecurity() {
    }

    @OverrideOnDemand
    protected void initUI() {
    }

    @OverrideOnDemand
    protected void initManagers() {
    }

    @OverrideOnDemand
    protected void initJobs() {
    }

    @OverrideOnDemand
    protected boolean isLogExceptions() {
        return true;
    }

    public final void contextInitialized(@Nonnull ServletContextEvent servletContextEvent) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start contextInitialized");
        }
        ServletContext servletContext = servletContextEvent.getServletContext();
        if (WebAppListener.isOnlyOneInstanceAllowed() && INITED.getAndSet(true)) {
            LOGGER.error("WebAppListener was already instantiated!");
            throw new IllegalStateException("WebAppListener was already instantiated!");
        }
        try {
            String string;
            StopWatch stopWatch = StopWatch.createdStarted();
            this.m_aInitializationStartDT = PDTFactory.getCurrentLocalDateTime();
            this.onTheVeryBeginning(servletContext);
            boolean bl = StringParser.parseBool((String)this.getInitParameterDebug(servletContext));
            boolean bl2 = StringParser.parseBool((String)this.getInitParameterProduction(servletContext));
            GlobalDebug.setDebugModeDirect((boolean)bl);
            GlobalDebug.setProductionModeDirect((boolean)bl2);
            boolean bl3 = StringParser.parseBool((String)this.getInitParameterNoStartupInfo(servletContext));
            if (!bl3) {
                this.logStartupInfo(servletContext);
            }
            if (StringHelper.isNotEmpty((String)(string = this.getInitParameterServerURL(servletContext, bl2)))) {
                URL uRL = URLHelper.getAsURL((String)string);
                if (uRL != null) {
                    StaticServerInfo.init((String)uRL.getProtocol(), (String)uRL.getHost(), (int)uRL.getPort(), (String)servletContext.getContextPath());
                } else {
                    LOGGER.error("The init-parameter for the server URL" + (bl2 ? " (production mode)" : " (non-production mode)") + "contains the non-URL value '" + string + "'");
                }
            }
            this.beforeContextInitialized(servletContext);
            if (WebAppListener.isOnlyOneInstanceAllowed() || !WebScopeManager.isGlobalScopePresent()) {
                WebScopeManager.onGlobalBegin((ServletContext)servletContext);
                PhotonCoreInit.startUp();
                this.initPaths(servletContext);
                this.initGlobalIDFactory();
                WebAppListener.initDefaultGlobalSettings();
                this.initGlobalSettings();
                this.initLocales(GlobalLocaleManager.getInstance());
                this.initMenu();
                this.initAjax(GlobalAjaxInvoker.getInstance().getRegistry());
                this.initAPI(GlobalAPIInvoker.getInstance().getRegistry());
                this.initSecurity();
                this.initUI();
                this.initManagers();
                this.initJobs();
            }
            this.afterContextInitialized(servletContext);
            this.m_aInitializationEndDT = PDTFactory.getCurrentLocalDateTime();
            LOGGER.info("Servlet context '" + servletContext.getServletContextName() + "' was initialized in " + stopWatch.stopAndGetMillis() + " milli seconds");
        }
        catch (RuntimeException runtimeException) {
            if (this.isLogExceptions()) {
                LOGGER.error("Context Initialization Error", (Throwable)runtimeException);
            }
            throw runtimeException;
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("End contextInitialized");
            }
        }
    }

    @Nullable
    public final LocalDateTime getInitializationStartDT() {
        return this.m_aInitializationStartDT;
    }

    @Nullable
    public final LocalDateTime getInitializationEndDT() {
        return this.m_aInitializationEndDT;
    }

    @OverrideOnDemand
    protected void beforeContextDestroyed(@Nonnull ServletContext servletContext) {
    }

    @OverrideOnDemand
    protected void afterContextDestroyed(@Nonnull ServletContext servletContext) {
    }

    public final boolean isHandleStatisticsOnEnd() {
        return this.m_bHandleStatisticsOnEnd;
    }

    @Nonnull
    public final WebAppListener setHandleStatisticsOnEnd(boolean bl) {
        this.m_bHandleStatisticsOnEnd = bl;
        return this;
    }

    @Nonnull
    @Nonempty
    @OverrideOnDemand
    protected String getStatisticsFilename() {
        return "statistics/" + PDTFactory.getCurrentYear() + "/statistics_" + PDTIOHelper.getCurrentLocalDateTimeForFilename() + ".xml";
    }

    @OverrideOnDemand
    protected void handleStatisticsOnEnd() {
        if (WebFileIO.isInited()) {
            try {
                IMicroDocument iMicroDocument = StatisticsExporter.getAsXMLDocument();
                iMicroDocument.getDocumentElement().setAttribute("location", "shutdown");
                iMicroDocument.getDocumentElement().setAttribute("datetime", PDTWebDateHelper.getAsStringXSD((LocalDateTime)PDTFactory.getCurrentLocalDateTime()));
                File file = WebFileIO.getDataIO().getFile(this.getStatisticsFilename());
                MicroWriter.writeToFile((IMicroNode)iMicroDocument, (File)file);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to write statistics on context shutdown", (Throwable)exception);
            }
        } else {
            LOGGER.error("Not writing statistics because WebFileIO was not initialized!");
        }
    }

    public final void contextDestroyed(@Nonnull ServletContextEvent servletContextEvent) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start contextDestroyed");
        }
        try {
            ServletContext servletContext = servletContextEvent.getServletContext();
            StopWatch stopWatch = StopWatch.createdStarted();
            LOGGER.info("Servlet context '" + servletContext.getServletContextName() + "' is being destroyed");
            this.beforeContextDestroyed(servletContext);
            WebScopeManager.onGlobalEnd();
            this.afterContextDestroyed(servletContext);
            if (this.isHandleStatisticsOnEnd()) {
                this.handleStatisticsOnEnd();
            }
            PhotonCoreInit.shutdown();
            if (WebAppListener.isOnlyOneInstanceAllowed()) {
                INITED.set(false);
            }
            LOGGER.info("Servlet context '" + servletContext.getServletContextName() + "' was destroyed in " + stopWatch.stopAndGetMillis() + " milli seconds");
        }
        catch (RuntimeException runtimeException) {
            if (this.isLogExceptions()) {
                LOGGER.error("Context Initialization Error", (Throwable)runtimeException);
            }
            throw runtimeException;
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("End contextDestroyed");
            }
        }
    }

    public final void sessionCreated(@Nonnull HttpSessionEvent httpSessionEvent) {
        HttpSession httpSession = httpSessionEvent.getSession();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("A new session was created: " + String.valueOf(httpSession));
        }
        WebScopeManager.onSessionBegin((HttpSession)httpSession);
    }

    public final void sessionDestroyed(@Nonnull HttpSessionEvent httpSessionEvent) {
        HttpSession httpSession = httpSessionEvent.getSession();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Destroying session: " + String.valueOf(httpSession));
        }
        WebScopeManager.onSessionEnd((HttpSession)httpSession);
    }

    public static void setSilentMode(boolean bl) {
        LocaleCache.setSilentMode((boolean)bl);
        CountryCache.setSilentMode((boolean)bl);
        LanguageCache.setSilentMode((boolean)bl);
        ObjectPool.setSilentMode((boolean)bl);
        TypeConverter.setSilentMode((boolean)bl);
        AbstractDAO.setSilentMode((boolean)bl);
        ServletContextPathHolder.setSilentMode((boolean)bl);
        XServletFilterConsistency.setSilentMode((boolean)bl);
        UnifiedResponse.setSilentMode((boolean)bl);
        HCSettings.setSilentMode((boolean)bl);
        WebSiteResourceCache.setSilentMode((boolean)bl);
        PhotonWorkerPool.setSilentMode((boolean)bl);
    }

    static {
        SystemProperties.setPropertyValue((String)"java.awt.headless", (String)"true");
        LOGGER = LoggerFactory.getLogger(WebAppListener.class);
        ONLY_ONE_INSTANCE_ALLOWED = new AtomicBoolean(true);
        INITED = new AtomicBoolean(false);
    }
}

