/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.servlet;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.servlet.ServletHelper;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;

public class ErrorXServletHandler
implements IXServletSimpleHandler {
    public static final String PARAM_HTTP_ERROR = "httpError";
    public static final String PARAM_HTTP_STATUS_CODE = "httpStatusCode";
    public static final String PARAM_HTTP_STATUS_MESSAGE = "httpStatusMessage";
    public static final String PARAM_HTTP_REQUEST_URI = "httpRequestUri";
    public static final String PARAM_HTTP_REFERRER = "httpReferrer";
    private final String m_sServletPath;

    public ErrorXServletHandler(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Path");
        ValueEnforcer.isTrue((boolean)string.startsWith("/"), (String)"Path must start with '/'!");
        this.m_sServletPath = string;
    }

    @Nonnull
    @Nonempty
    public final String getPath() {
        return this.m_sServletPath;
    }

    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws Exception {
        HttpServletRequest httpServletRequest = iRequestWebScopeWithoutResponse.getRequest();
        SimpleURL simpleURL = new SimpleURL(iRequestWebScopeWithoutResponse.getContextPath() + this.m_sServletPath);
        simpleURL.add(PARAM_HTTP_ERROR, true);
        simpleURL.addIfNotNull(PARAM_HTTP_STATUS_CODE, StringHelper.getToString((Object)ServletHelper.getRequestAttribute((ServletRequest)httpServletRequest, (String)"jakarta.servlet.error.status_code")));
        simpleURL.addIfNotNull(PARAM_HTTP_STATUS_MESSAGE, StringHelper.getToString((Object)ServletHelper.getRequestAttribute((ServletRequest)httpServletRequest, (String)"jakarta.servlet.error.message")));
        simpleURL.addIfNotNull(PARAM_HTTP_REQUEST_URI, StringHelper.getToString((Object)ServletHelper.getRequestAttribute((ServletRequest)httpServletRequest, (String)"jakarta.servlet.error.request_uri")));
        simpleURL.addIfNotNull(PARAM_HTTP_REFERRER, iRequestWebScopeWithoutResponse.headers().getFirstHeaderValue("Referer"));
        unifiedResponse.setRedirect((ISimpleURL)simpleURL);
    }
}

