/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.servlet;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ELockType;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.IsLocked;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsSet;
import com.helger.http.EHttpMethod;
import com.helger.http.EHttpVersion;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.serialize.JsonReader;
import com.helger.json.serialize.JsonWriterSettings;
import com.helger.web.scope.IRequestWebScope;
import com.helger.xservlet.handler.IXServletHandler;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CSPReportingXServletHandler
implements IXServletHandler {
    public static final boolean DEFAULT_FILTER_DUPLICATES = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(CSPReportingXServletHandler.class);
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final Consumer<? super IJsonObject> m_aJsonHandler;
    @GuardedBy(value="m_aRWLock")
    private boolean m_bFilterDuplicates = true;
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<String> m_aBlockedURIs = new CommonsHashSet();

    public CSPReportingXServletHandler() {
        this(CSPReportingXServletHandler::logCSPReport);
    }

    public CSPReportingXServletHandler(@Nonnull Consumer<? super IJsonObject> consumer) {
        this.m_aJsonHandler = (Consumer)ValueEnforcer.notNull(consumer, (String)"JsonHandler");
    }

    @Nonnull
    public final Consumer<? super IJsonObject> getJsonHandler() {
        return this.m_aJsonHandler;
    }

    public final boolean isFilterDuplicates() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bFilterDuplicates);
    }

    public final void setFilterDuplicates(boolean bl) {
        this.m_aRWLock.writeLocked(() -> {
            this.m_bFilterDuplicates = bl;
        });
    }

    @IsLocked(value=ELockType.WRITE)
    protected final boolean rememberBlockedURL(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"BlockedURI");
        return this.m_aRWLock.writeLockedBoolean(() -> !this.m_aBlockedURIs.add((Object)string));
    }

    public static void logCSPReport(@Nonnull IJsonObject iJsonObject) {
        LOGGER.warn("CSP report: " + iJsonObject.getAsJsonString(JsonWriterSettings.DEFAULT_SETTINGS_FORMATTED));
    }

    public void onRequest(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull IRequestWebScope iRequestWebScope) throws ServletException, IOException {
        byte[] byArray = StreamHelper.getAllBytes((InputStream)httpServletRequest.getInputStream());
        IJson iJson = JsonReader.builder().source(byArray).read();
        if (iJson != null) {
            if (iJson.isObject()) {
                boolean bl;
                IJsonObject iJsonObject = iJson.getAsObject();
                String string = iJsonObject.getAsString((Object)"blocked-uri");
                boolean bl2 = bl = this.isFilterDuplicates() && StringHelper.isNotEmpty((String)string) && this.rememberBlockedURL(string);
                if (bl) {
                    LOGGER.info("Ignoring already blocked CSP URI '" + string + "'");
                } else {
                    this.m_aJsonHandler.accept((IJsonObject)iJson.getAsObject());
                }
            } else {
                LOGGER.error("Weird JSON received: " + iJson.getAsJsonString(JsonWriterSettings.DEFAULT_SETTINGS_FORMATTED));
            }
        } else {
            LOGGER.error("Failed to parse CSP report JSON: " + new String(byArray, StandardCharsets.ISO_8859_1));
        }
        httpServletResponse.setStatus(202);
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsSet<String> getAllBlockedURIs() {
        return (ICommonsSet)this.m_aRWLock.readLockedGet(() -> this.m_aBlockedURIs.getClone());
    }

    @Nonnull
    public final EChange clearAllBlockedURIs() {
        return (EChange)this.m_aRWLock.readLockedGet(() -> this.m_aBlockedURIs.removeAll());
    }
}

