/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.servlet;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.state.EContinue;
import com.helger.http.CHttp;
import com.helger.io.resource.IReadableResource;
import com.helger.mime.EMimeContentType;
import com.helger.photon.core.servlet.AbstractObjectDeliveryHttpHandler;
import com.helger.servlet.response.ResponseHelperSettings;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.statistics.api.IMutableStatisticsHandlerCounter;
import com.helger.statistics.api.IMutableStatisticsHandlerKeyedCounter;
import com.helger.statistics.impl.StatisticsManager;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xml.serialize.write.XMLWriterSettings;
import com.helger.xml.util.mime.MimeTypeInfoManager;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceDeliveryHttpHandler
extends AbstractObjectDeliveryHttpHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractResourceDeliveryHttpHandler.class);
    private final IMutableStatisticsHandlerCounter m_aStatsRequests = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$requests"));
    private final IMutableStatisticsHandlerKeyedCounter m_aStatsSuccess = StatisticsManager.getKeyedCounterHandler((String)(this.getClass().getName() + "$success"));
    private final IMutableStatisticsHandlerKeyedCounter m_aStatsNotFound = StatisticsManager.getKeyedCounterHandler((String)(this.getClass().getName() + "$notfound"));
    private final IMutableStatisticsHandlerKeyedCounter m_aStatsMIMEType = StatisticsManager.getKeyedCounterHandler((String)(this.getClass().getName() + "$mimetype"));
    private static final String REQUEST_ATTR_OBJECT_DELIVERY_RESOURCE = "$ph-stream.resource";

    protected AbstractResourceDeliveryHttpHandler() {
    }

    @Nonnull
    protected abstract IReadableResource getResource(@Nonnull IRequestWebScopeWithoutResponse var1, @Nonnull String var2);

    @Override
    @OverridingMethodsMustInvokeSuper
    public EContinue initRequestState(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) {
        if (super.initRequestState(iRequestWebScopeWithoutResponse, unifiedResponse).isBreak()) {
            return EContinue.BREAK;
        }
        String string = iRequestWebScopeWithoutResponse.attrs().getAsString((Object)"$ph-object-delivery.filename");
        IReadableResource iReadableResource = this.getResource(iRequestWebScopeWithoutResponse, string);
        if (!iReadableResource.exists()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Not streaming '" + string + "' because no such resource exists.");
            }
            this.m_aStatsNotFound.increment(string);
            unifiedResponse.setStatus(404);
            return EContinue.BREAK;
        }
        iRequestWebScopeWithoutResponse.attrs().putIn((Object)REQUEST_ATTR_OBJECT_DELIVERY_RESOURCE, (Object)iReadableResource);
        return EContinue.CONTINUE;
    }

    @Nullable
    public LocalDateTime getLastModificationDateTime(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        long l;
        IReadableResource iReadableResource = (IReadableResource)iRequestWebScopeWithoutResponse.attrs().getCastedValue((Object)REQUEST_ATTR_OBJECT_DELIVERY_RESOURCE);
        File file = iReadableResource.getAsFile();
        if (file != null && (l = file.lastModified()) > 0L) {
            return CHttp.convertMillisToLocalDateTime((long)l);
        }
        return null;
    }

    @OverrideOnDemand
    protected boolean objectsAllowsForHTTPCaching(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull String string) {
        return true;
    }

    @Nullable
    @OverrideOnDemand
    protected String determineMimeType(@Nonnull String string, @Nonnull IReadableResource iReadableResource) {
        return MimeTypeInfoManager.getDefaultInstance().getPrimaryMimeTypeStringForFilename(string);
    }

    @Override
    protected void onDeliverResource(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse, @Nonnull String string) throws IOException {
        this.m_aStatsRequests.increment();
        IReadableResource iReadableResource = (IReadableResource)iRequestWebScopeWithoutResponse.attrs().getCastedValue((Object)REQUEST_ATTR_OBJECT_DELIVERY_RESOURCE);
        String string2 = this.determineMimeType(string, iReadableResource);
        if (string2 != null) {
            this.m_aStatsMIMEType.increment(string2);
            unifiedResponse.setMimeTypeString(string2);
            if (EMimeContentType.TEXT.isTypeOf(string2)) {
                unifiedResponse.setCharset(XMLWriterSettings.DEFAULT_XML_CHARSET_OBJ);
            }
        } else {
            LOGGER.warn("Failed to determine MIME type for filename '" + string + "'");
        }
        if (this.objectsAllowsForHTTPCaching(iRequestWebScopeWithoutResponse, string)) {
            unifiedResponse.enableCaching(ResponseHelperSettings.getExpirationSeconds());
        } else {
            unifiedResponse.disableCaching();
        }
        unifiedResponse.setContent((IHasInputStream)iReadableResource);
        this.m_aStatsSuccess.increment(string);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Successfully streamed resource '" + string + "' via " + this.getClass().getName());
        }
    }
}

