/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.servlet;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.numeric.MathHelper;
import com.helger.base.state.EContinue;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringReplace;
import com.helger.cache.regex.RegExHelper;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.io.file.FilenameHelper;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.url.codec.URLCoder;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObjectDeliveryHttpHandler
implements IXServletSimpleHandler {
    public static final String INITPARAM_DENIED_FILENAMES = "deniedFilenames";
    public static final String INITPARAM_DENIED_EXTENSIONS = "deniedExtensions";
    public static final String INITPARAM_DENIED_REG_EXS = "deniedRegExs";
    public static final String INITPARAM_ALLOWED_FILENAMES = "allowedFilenames";
    public static final String INITPARAM_ALLOWED_EXTENSIONS = "allowedExtensions";
    public static final String INITPARAM_ALLOWED_REG_EXS = "allowedRegExs";
    public static final String INITPARAM_VALUE_WILDCARD = "*";
    public static final String EXTENSION_MACRO_WEB_DEFAULT = "$web-default$";
    public static final String WEB_DEFAULT_EXTENSIONS = "js,css,png,jpg,jpeg,gif,eot,svg,ttf,woff,woff2,map";
    protected static final String REQUEST_ATTR_OBJECT_DELIVERY_FILENAME = "$ph-object-delivery.filename";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractObjectDeliveryHttpHandler.class);
    protected static final String ETAG_VALUE_OBJECT_DELIVERY_SERVLET = "\"" + Long.toString(MathHelper.abs((long)ThreadLocalRandom.current().nextLong()), 16) + "\"";
    private final ICommonsOrderedSet<String> m_aDeniedFilenames = new CommonsLinkedHashSet();
    private final ICommonsOrderedSet<String> m_aDeniedExtensions = new CommonsLinkedHashSet();
    private final ICommonsOrderedSet<String> m_aDeniedRegExs = new CommonsLinkedHashSet();
    private final ICommonsOrderedSet<String> m_aAllowedFilenames = new CommonsLinkedHashSet();
    private final ICommonsOrderedSet<String> m_aAllowedExtensions = new CommonsLinkedHashSet();
    private final ICommonsOrderedSet<String> m_aAllowedRegExs = new CommonsLinkedHashSet();
    private boolean m_bDeniedAllExtensions = false;
    private boolean m_bAllowedAllExtensions = false;

    protected AbstractObjectDeliveryHttpHandler() {
    }

    @Nonnull
    protected static final String getUnifiedItem(@Nonnull String string) {
        return string.toLowerCase(Locale.US);
    }

    private static void _initialFillSet(@Nonnull ICommonsOrderedSet<String> iCommonsOrderedSet, @Nullable String string, boolean bl) {
        ValueEnforcer.notNull(iCommonsOrderedSet, (String)"Set");
        if (!iCommonsOrderedSet.isEmpty()) {
            throw new IllegalArgumentException("The provided set must be empty, but it is not: " + String.valueOf(iCommonsOrderedSet));
        }
        if (StringHelper.isNotEmpty((String)string)) {
            String string2 = StringReplace.replaceAll((String)string, (String)EXTENSION_MACRO_WEB_DEFAULT, (CharSequence)WEB_DEFAULT_EXTENSIONS);
            for (String string3 : StringHelper.getExploded((char)',', (String)string2)) {
                String string4 = string3.trim();
                if (bl) {
                    string4 = AbstractObjectDeliveryHttpHandler.getUnifiedItem(string4);
                }
                if (!StringHelper.isNotEmpty((String)string4)) continue;
                iCommonsOrderedSet.add((Object)string4);
            }
        }
    }

    public void onServletInit(@Nonnull ICommonsMap<String, String> iCommonsMap) {
        AbstractObjectDeliveryHttpHandler._initialFillSet(this.m_aDeniedFilenames, (String)iCommonsMap.get((Object)INITPARAM_DENIED_FILENAMES), false);
        AbstractObjectDeliveryHttpHandler._initialFillSet(this.m_aDeniedExtensions, (String)iCommonsMap.get((Object)INITPARAM_DENIED_EXTENSIONS), true);
        AbstractObjectDeliveryHttpHandler._initialFillSet(this.m_aDeniedRegExs, (String)iCommonsMap.get((Object)INITPARAM_DENIED_REG_EXS), false);
        this.m_bDeniedAllExtensions = this.m_aDeniedExtensions.contains((Object)INITPARAM_VALUE_WILDCARD);
        AbstractObjectDeliveryHttpHandler._initialFillSet(this.m_aAllowedFilenames, (String)iCommonsMap.get((Object)INITPARAM_ALLOWED_FILENAMES), false);
        AbstractObjectDeliveryHttpHandler._initialFillSet(this.m_aAllowedExtensions, (String)iCommonsMap.get((Object)INITPARAM_ALLOWED_EXTENSIONS), true);
        AbstractObjectDeliveryHttpHandler._initialFillSet(this.m_aAllowedRegExs, (String)iCommonsMap.get((Object)INITPARAM_ALLOWED_REG_EXS), false);
        this.m_bAllowedAllExtensions = this.m_aAllowedExtensions.contains((Object)INITPARAM_VALUE_WILDCARD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Settings for " + this.getClass().getName() + ": deniedFilenames=" + String.valueOf(this.m_aDeniedFilenames) + "; deniedExtensions=" + String.valueOf(this.m_aDeniedExtensions) + "; deniedRegExs=" + String.valueOf(this.m_aDeniedRegExs) + "; allowedFilenames=" + String.valueOf(this.m_aAllowedFilenames) + "; allowedExtensions=" + String.valueOf(this.m_aAllowedExtensions) + "; allowedRegExs=" + String.valueOf(this.m_aAllowedRegExs));
        }
        if (this.m_bDeniedAllExtensions) {
            LOGGER.warn("All extensions are denied in " + this.getClass().getName() + ". This means that this servlet will not deliver any resource!");
        } else if (this.m_aAllowedFilenames.isEmpty() && this.m_aAllowedExtensions.isEmpty() && this.m_aAllowedRegExs.isEmpty()) {
            LOGGER.warn("No allowance rules are defined in " + this.getClass().getName() + ". This means that this servlet will not deliver any resource!");
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    protected final ICommonsOrderedSet<String> getAllDeniedFilenames() {
        return this.m_aDeniedFilenames.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    protected final ICommonsOrderedSet<String> getAllDeniedExtensions() {
        return this.m_aDeniedExtensions.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    protected final ICommonsOrderedSet<String> getAllDeniedRegExs() {
        return this.m_aDeniedRegExs.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    protected final ICommonsOrderedSet<String> getAllAllowedFilenames() {
        return this.m_aAllowedFilenames.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    protected final ICommonsOrderedSet<String> getAllAllowedExtensions() {
        return this.m_aAllowedExtensions.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    protected final ICommonsOrderedSet<String> getAllAllowedRegExs() {
        return this.m_aAllowedRegExs.getClone();
    }

    protected final boolean isDenyAllExtensions() {
        return this.m_bDeniedAllExtensions;
    }

    protected final boolean isAllowAllExtensions() {
        return this.m_bAllowedAllExtensions;
    }

    protected final boolean isValidFilenameAccordingToTheRules(@Nullable String string) {
        String string2 = FilenameHelper.getWithoutPath((String)string);
        String string3 = AbstractObjectDeliveryHttpHandler.getUnifiedItem(FilenameHelper.getExtension((String)string2));
        if (StringHelper.endsWith((String)string, (String)"/") || StringHelper.isEmpty((String)string2)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Denied object with name '" + string + "' because it is empty");
            }
            return false;
        }
        if (this.m_aDeniedFilenames.contains((Object)string2)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Denied object with name '" + string + "' because it is in the denied filenames list");
            }
            return false;
        }
        if (this.m_bDeniedAllExtensions || this.m_aDeniedExtensions.contains((Object)string3)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Denied object with name '" + string + "' because it is in the denied extension list");
            }
            return false;
        }
        if (!this.m_aDeniedRegExs.isEmpty()) {
            for (String string4 : this.m_aDeniedRegExs) {
                if (!RegExHelper.stringMatchesPattern((String)string4, (String)string2)) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Denied object with name '" + string + "' because it is in the denied regex list");
                }
                return false;
            }
        }
        if (this.m_aAllowedFilenames.contains((Object)string2)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Allowed object with name '" + string + "' because it is in the allowed filenames list");
            }
            return true;
        }
        if (this.m_bAllowedAllExtensions || this.m_aAllowedExtensions.contains((Object)string3)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Allowed object with name '" + string + "' because it is in the allowed extension list");
            }
            return true;
        }
        if (!this.m_aAllowedRegExs.isEmpty()) {
            for (String string4 : this.m_aAllowedRegExs) {
                if (!RegExHelper.stringMatchesPattern((String)string4, (String)string2)) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Allowed object with name '" + string + "' because it is in the allowed regex list");
                }
                return true;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Denied object with name '" + string + "' because it is neither denied nor allowed");
        }
        return false;
    }

    protected static final boolean isPossibleDirectoryTraversalRequest(@Nonnull String string) {
        return string.indexOf("/..") >= 0 || string.indexOf("../") >= 0 || string.indexOf("\\..") >= 0 || string.indexOf("..\\") >= 0;
    }

    @OverridingMethodsMustInvokeSuper
    public EContinue initRequestState(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) {
        String string = URLCoder.urlDecodeOrNull((String)iRequestWebScopeWithoutResponse.getPathWithinServlet());
        if (StringHelper.isEmpty((String)string) || !this.isValidFilenameAccordingToTheRules(string) || AbstractObjectDeliveryHttpHandler.isPossibleDirectoryTraversalRequest(string)) {
            LOGGER.warn("Illegal delivery request '" + string + "'");
            unifiedResponse.setStatus(404);
            return EContinue.BREAK;
        }
        iRequestWebScopeWithoutResponse.attrs().putIn((Object)REQUEST_ATTR_OBJECT_DELIVERY_FILENAME, (Object)string);
        return EContinue.CONTINUE;
    }

    @Nullable
    public final String getSupportedETag(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        return ETAG_VALUE_OBJECT_DELIVERY_SERVLET;
    }

    protected abstract void onDeliverResource(@Nonnull IRequestWebScopeWithoutResponse var1, @Nonnull UnifiedResponse var2, @Nonnull String var3) throws IOException;

    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws ServletException, IOException {
        String string = iRequestWebScopeWithoutResponse.attrs().getAsString((Object)REQUEST_ATTR_OBJECT_DELIVERY_FILENAME);
        this.onDeliverResource(iRequestWebScopeWithoutResponse, unifiedResponse, string);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Delivered object with name '" + string + "'");
        }
    }
}

