/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.servlet;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.state.EContinue;
import com.helger.photon.app.html.IHTMLProvider;
import com.helger.photon.app.html.PhotonHTMLHelper;
import com.helger.photon.core.interror.InternalErrorBuilder;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApplicationXServletHandler
implements IXServletSimpleHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractApplicationXServletHandler.class);

    protected AbstractApplicationXServletHandler() {
    }

    @OverrideOnDemand
    protected void invokeInternalErrorHandler(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull Throwable throwable) {
        new InternalErrorBuilder().setThrowable(throwable).setRequestScope(iRequestWebScopeWithoutResponse).addErrorMessage("Error running application servlet " + this.getClass().getSimpleName()).handle();
    }

    @Nonnull
    public EContinue onException(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse, @Nonnull Throwable throwable) {
        if (!GlobalDebug.isDebugMode()) {
            this.invokeInternalErrorHandler(iRequestWebScopeWithoutResponse, throwable);
            return EContinue.BREAK;
        }
        return EContinue.CONTINUE;
    }

    @Nonnull
    protected abstract IHTMLProvider createHTMLProvider(@Nonnull IRequestWebScopeWithoutResponse var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OverridingMethodsMustInvokeSuper
    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws IOException, ServletException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start handleRequest");
        }
        try {
            IHTMLProvider iHTMLProvider = this.createHTMLProvider(iRequestWebScopeWithoutResponse);
            PhotonHTMLHelper.createHTMLResponse((IRequestWebScopeWithoutResponse)iRequestWebScopeWithoutResponse, (UnifiedResponse)unifiedResponse, (IHTMLProvider)iHTMLProvider);
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("End handleRequest");
            }
        }
    }
}

