/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.resource;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.state.EContinue;
import com.helger.io.file.FilenameHelper;
import com.helger.photon.app.PhotonAppManager;
import com.helger.photon.app.resource.WebSiteResourceBundleSerialized;
import com.helger.photon.core.servlet.AbstractObjectDeliveryHttpHandler;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBundleDeliveryHttpHandler
extends AbstractObjectDeliveryHttpHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceBundleDeliveryHttpHandler.class);

    @Nonnull
    private static String _getBundleIDFromFilename(@Nonnull String string) {
        return FilenameHelper.getBaseName((String)string);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public EContinue initRequestState(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) {
        if (super.initRequestState(iRequestWebScopeWithoutResponse, unifiedResponse).isBreak()) {
            return EContinue.BREAK;
        }
        String string = ResourceBundleDeliveryHttpHandler._getBundleIDFromFilename(iRequestWebScopeWithoutResponse.attrs().getAsString((Object)"$ph-object-delivery.filename"));
        if (!PhotonAppManager.getWebSiteResourceBundleMgr().containsResourceBundleOfID(string)) {
            LOGGER.warn("Failed to resolve resource bundle with ID '" + string + "'");
            unifiedResponse.setStatus(404);
            return EContinue.BREAK;
        }
        return EContinue.CONTINUE;
    }

    @Nonnegative
    protected int getCachingDays() {
        return 30;
    }

    @Override
    protected void onDeliverResource(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse, @Nonnull String string) throws IOException {
        String string2 = ResourceBundleDeliveryHttpHandler._getBundleIDFromFilename(string);
        WebSiteResourceBundleSerialized webSiteResourceBundleSerialized = PhotonAppManager.getWebSiteResourceBundleMgr().getResourceBundleOfID(string2);
        int n = this.getCachingDays();
        unifiedResponse.enableCaching(86400 * n).setMimeType(webSiteResourceBundleSerialized.getMimeType()).setContent((IHasInputStream)webSiteResourceBundleSerialized).setCharset(StandardCharsets.UTF_8);
    }
}

