/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.requestparam;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.UsedViaReflection;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.photon.core.appid.PhotonGlobalState;
import com.helger.photon.core.requestparam.IRequestParameterHandler;
import com.helger.photon.core.requestparam.IRequestParameterManager;
import com.helger.photon.core.requestparam.RequestParameterHandlerURLParameter;
import com.helger.url.SimpleURL;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.web.scope.singleton.AbstractGlobalWebSingleton;
import jakarta.annotation.Nonnull;
import java.util.Locale;

@NotThreadSafe
public class RequestParameterManager
extends AbstractGlobalWebSingleton
implements IRequestParameterManager {
    private IRequestParameterHandler m_aRequestParamHdl = new RequestParameterHandlerURLParameter();

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public RequestParameterManager() {
    }

    @Nonnull
    public static RequestParameterManager getInstance() {
        return (RequestParameterManager)RequestParameterManager.getGlobalSingleton(RequestParameterManager.class);
    }

    @Override
    @Nonnull
    public final IRequestParameterHandler getParameterHandler() {
        return this.m_aRequestParamHdl;
    }

    @Override
    public final void setParameterHandler(@Nonnull IRequestParameterHandler iRequestParameterHandler) {
        ValueEnforcer.notNull((Object)iRequestParameterHandler, (String)"RequestParameterHdl");
        this.m_aRequestParamHdl = iRequestParameterHandler;
    }

    @Override
    @Nonnull
    public SimpleURL getLinkToMenuItem(@Nonnull @Nonempty String string, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull Locale locale, @Nonnull String string2) {
        String string3 = PhotonGlobalState.state(string).getServletPath();
        String string4 = iRequestWebScopeWithoutResponse.getContextPath() + string3;
        return this.m_aRequestParamHdl.buildURL(iRequestWebScopeWithoutResponse, string4, locale, string2);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("RequestParamHandler", (Object)this.m_aRequestParamHdl).getToString();
    }
}

