/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.requestparam;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.photon.core.locale.GlobalLocaleManager;
import com.helger.photon.core.menu.IMenuTree;
import com.helger.photon.core.requestparam.IRequestParameterHandler;
import com.helger.photon.core.requestparam.PhotonRequestParameters;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class RequestParameterHandlerURLPathOrdered
implements IRequestParameterHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestParameterHandlerURLPathOrdered.class);

    @Nonnull
    protected PhotonRequestParameters getParametersFromPath(@Nonnull String string, @Nonnull IMenuTree iMenuTree) {
        PhotonRequestParameters photonRequestParameters = new PhotonRequestParameters();
        for (String string2 : StringHelper.getExploded((char)'/', (String)StringHelper.trimStartAndEnd((String)string, (String)"/"))) {
            if (!photonRequestParameters.hasLocale() && photonRequestParameters.setLocaleFromString(GlobalLocaleManager.getInstance(), string2) != null || !photonRequestParameters.hasMenuItem() && photonRequestParameters.setMenuItemFromString(iMenuTree, string2) != null || !LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Ignoring superfluous parameter '" + string2 + "'");
        }
        return photonRequestParameters;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public PhotonRequestParameters getParametersFromRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull IMenuTree iMenuTree) {
        return this.getParametersFromPath(iRequestWebScopeWithoutResponse.getPathInfo(), iMenuTree);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public PhotonRequestParameters getParametersFromURL(@Nonnull ISimpleURL iSimpleURL, @Nonnull IMenuTree iMenuTree) {
        return this.getParametersFromPath(iSimpleURL.getPath(), iMenuTree);
    }

    @Override
    @Nonnull
    public SimpleURL buildURL(@Nullable IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull @Nonempty String string, @Nullable Locale locale, @Nullable String string2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (locale != null) {
            stringBuilder.append('/').append(locale.toString());
        }
        if (StringHelper.isNotEmpty((String)string2)) {
            stringBuilder.append('/').append(string2);
        }
        String string3 = stringBuilder.toString();
        return new SimpleURL(iRequestWebScopeWithoutResponse != null ? iRequestWebScopeWithoutResponse.encodeURL(string3) : string3);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

