/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.requestparam;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.photon.core.locale.GlobalLocaleManager;
import com.helger.photon.core.menu.IMenuTree;
import com.helger.photon.core.requestparam.AbstractRequestParameterHandlerNamed;
import com.helger.photon.core.requestparam.PhotonRequestParameters;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class RequestParameterHandlerURLPathNamed
extends AbstractRequestParameterHandlerNamed {
    public static final char DEFAULT_SEPARATOR_CHAR = '-';
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestParameterHandlerURLPathNamed.class);
    private final String m_sSeparator;

    public RequestParameterHandlerURLPathNamed() {
        this(Character.toString('-'));
    }

    public RequestParameterHandlerURLPathNamed(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Separator");
        ValueEnforcer.isTrue((string.indexOf(47) < 0 ? 1 : 0) != 0, (String)"The separator may not contain a path delimiter '/'!");
        this.m_sSeparator = string;
    }

    @Nonnull
    @Nonempty
    public String getSeparator() {
        return this.m_sSeparator;
    }

    @Nonnull
    protected PhotonRequestParameters getParametersFromPath(@Nonnull String string, @Nonnull IMenuTree iMenuTree) {
        PhotonRequestParameters photonRequestParameters = new PhotonRequestParameters();
        for (String string2 : StringHelper.getExploded((char)'/', (String)StringHelper.trimStartAndEnd((String)string, (String)"/"))) {
            List list = StringHelper.getExploded((String)this.m_sSeparator, (String)string2, (int)2);
            if (list.size() != 2) continue;
            String string3 = (String)list.get(0);
            String string4 = (String)list.get(1);
            if (string3.equals(this.getRequestParamNameLocale())) {
                photonRequestParameters.setLocaleFromString(GlobalLocaleManager.getInstance(), string4);
                continue;
            }
            if (string3.equals(this.getRequestParamNameMenuItem())) {
                photonRequestParameters.setMenuItemFromString(iMenuTree, string4);
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Ignoring superfluous parameter '" + string3 + "' with value '" + string4 + "'");
        }
        return photonRequestParameters;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public PhotonRequestParameters getParametersFromRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull IMenuTree iMenuTree) {
        return this.getParametersFromPath(iRequestWebScopeWithoutResponse.getPathInfo(), iMenuTree);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public PhotonRequestParameters getParametersFromURL(@Nonnull ISimpleURL iSimpleURL, @Nonnull IMenuTree iMenuTree) {
        return this.getParametersFromPath(iSimpleURL.getPath(), iMenuTree);
    }

    @Override
    @Nonnull
    public SimpleURL buildURL(@Nullable IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull @Nonempty String string, @Nullable Locale locale, @Nullable String string2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (locale != null) {
            stringBuilder.append('/').append(this.getRequestParamNameLocale()).append(this.m_sSeparator).append(locale.toString());
        }
        if (StringHelper.isNotEmpty((String)string2)) {
            stringBuilder.append('/').append(this.getRequestParamNameMenuItem()).append(this.m_sSeparator).append(string2);
        }
        String string3 = stringBuilder.toString();
        return new SimpleURL(iRequestWebScopeWithoutResponse != null ? iRequestWebScopeWithoutResponse.encodeURL(string3) : string3);
    }

    @Override
    public boolean isValidParameterName(@Nonnull String string) {
        return string.indexOf(this.m_sSeparator) < 0 && string.indexOf(47) < 0 && string.indexOf(63) < 0;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Separator", (Object)this.m_sSeparator).getToString();
    }
}

