/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.requestparam;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.photon.core.locale.ILocaleManager;
import com.helger.photon.core.menu.IMenuItemPage;
import com.helger.photon.core.menu.IMenuItemRedirectToPage;
import com.helger.photon.core.menu.IMenuObject;
import com.helger.photon.core.menu.IMenuOperations;
import com.helger.text.locale.LocaleCache;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class PhotonRequestParameters
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotonRequestParameters.class);
    private Locale m_aLocale;
    private IMenuItemPage m_aMenuItem;

    @Nullable
    public Locale getLocale() {
        return this.m_aLocale;
    }

    @Nullable
    public String getLocaleAsString() {
        return this.m_aLocale == null ? null : this.m_aLocale.toString();
    }

    public boolean hasLocale() {
        return this.m_aLocale != null;
    }

    public void setLocale(@Nullable Locale locale) {
        this.m_aLocale = locale;
    }

    @Nullable
    public Locale setLocaleFromString(@Nonnull ILocaleManager iLocaleManager, @Nullable String string) {
        Locale locale;
        Locale locale2 = null;
        if (StringHelper.isNotEmpty((String)string) && (locale = LocaleCache.getInstance().getLocale(string)) != null && iLocaleManager.isSupportedLocale(locale)) {
            locale2 = locale;
        }
        this.setLocale(locale2);
        return locale2;
    }

    @Nullable
    public IMenuItemPage getMenuItem() {
        return this.m_aMenuItem;
    }

    @Nullable
    public String getMenuItemAsString() {
        return this.m_aMenuItem == null ? null : (String)this.m_aMenuItem.getID();
    }

    public boolean hasMenuItem() {
        return this.m_aMenuItem != null;
    }

    @Nullable
    public IMenuItemPage setMenuItemFromString(@Nonnull IMenuOperations iMenuOperations, @Nullable String string) {
        IMenuObject iMenuObject;
        IMenuItemPage iMenuItemPage = null;
        if (StringHelper.isNotEmpty((String)string) && (iMenuObject = iMenuOperations.getMenuObjectOfID(string)) != null) {
            IMenuItemPage iMenuItemPage2;
            if (iMenuObject instanceof IMenuItemPage) {
                if (iMenuObject.matchesDisplayFilter()) {
                    iMenuItemPage = (IMenuItemPage)iMenuObject;
                }
            } else if (iMenuObject instanceof IMenuItemRedirectToPage && iMenuObject.matchesDisplayFilter() && (iMenuItemPage2 = ((IMenuItemRedirectToPage)iMenuObject).getTargetMenuItemPage()).matchesDisplayFilter()) {
                iMenuItemPage = iMenuItemPage2;
                LOGGER.info("Following a redirect from '" + (String)iMenuObject.getID() + "' to '" + (String)iMenuItemPage2.getID() + "'");
            }
        }
        this.m_aMenuItem = iMenuItemPage;
        return iMenuItemPage;
    }

    public String toString() {
        return new ToStringGenerator(null).append("Locale", (Object)this.m_aLocale).append("MenuItem", (Object)this.m_aMenuItem).getToString();
    }
}

