/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.page;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsMap;
import com.helger.photon.core.page.IPage;
import com.helger.text.IMultilingualText;
import com.helger.text.ReadOnlyMultilingualText;
import com.helger.text.locale.LocaleHelper;
import com.helger.typeconvert.collection.AttributeContainerAny;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

@NotThreadSafe
public abstract class AbstractPage
implements IPage {
    private final String m_sID;
    private IMultilingualText m_aName;
    private IMultilingualText m_aDescription;
    private final AttributeContainerAny<String> m_aAttrs = new AttributeContainerAny();

    @Nullable
    public static ReadOnlyMultilingualText getAsMLT(@Nullable String string) {
        return string == null ? null : new ReadOnlyMultilingualText(LocaleHelper.LOCALE_INDEPENDENT, string);
    }

    public AbstractPage(@Nonnull @Nonempty String string) {
        this.m_sID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
    }

    public AbstractPage(@Nonnull @Nonempty String string, @Nonnull String string2) {
        this(string, (IMultilingualText)AbstractPage.getAsMLT(string2));
    }

    public AbstractPage(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        this(string, (IMultilingualText)AbstractPage.getAsMLT(string2), (IMultilingualText)AbstractPage.getAsMLT(string3));
    }

    public AbstractPage(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText) {
        this(string, iMultilingualText, null);
    }

    public AbstractPage(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        this(string);
        this.setName(iMultilingualText);
        this.setDescription(iMultilingualText2);
    }

    @Nonnull
    @Nonempty
    public final String getID() {
        return this.m_sID;
    }

    public final void setName(@Nonnull IMultilingualText iMultilingualText) {
        this.m_aName = (IMultilingualText)ValueEnforcer.notNull((Object)iMultilingualText, (String)"Name");
    }

    @Nonnull
    public final IMultilingualText getName() {
        return this.m_aName;
    }

    @Nullable
    public final String getDisplayText(@Nonnull Locale locale) {
        return this.m_aName == null ? null : this.m_aName.getText(locale);
    }

    public final void setDescription(@Nullable IMultilingualText iMultilingualText) {
        this.m_aDescription = iMultilingualText;
    }

    @Nullable
    public final IMultilingualText getDescription() {
        return this.m_aDescription;
    }

    @Override
    @Nullable
    public final String getDescription(@Nonnull Locale locale) {
        return this.m_aDescription == null ? null : this.m_aDescription.getText(locale);
    }

    @Nonnull
    @ReturnsMutableObject
    public final AttributeContainerAny<String> attrs() {
        return this.m_aAttrs;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).appendIfNotNull("Name", (Object)this.m_aName).appendIfNotNull("Description", (Object)this.m_aDescription).appendIf("Attrs", this.m_aAttrs, ICommonsMap::isNotEmpty).getToString();
    }
}

