/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.mock;

import com.helger.annotation.concurrent.Immutable;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.IReadableResource;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.app.html.PhotonJS;
import com.helger.photon.core.mock.PhotonCoreWebAppTestRule;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.microdom.util.MicroRecursiveIterator;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PhotonCoreValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotonCoreValidator.class);

    private PhotonCoreValidator() {
    }

    public static void validateWebXML() throws Exception {
        IMicroDocument iMicroDocument = MicroReader.readMicroXML((File)new File("src/main/webapp/WEB-INF/web.xml"));
        if (iMicroDocument != null) {
            for (IMicroNode iMicroNode : new MicroRecursiveIterator((IMicroNode)iMicroDocument.getDocumentElement())) {
                IMicroElement iMicroElement;
                if (!iMicroNode.isElement() || !(iMicroElement = (IMicroElement)iMicroNode).getTagName().endsWith("-class")) continue;
                String string = iMicroElement.getTextContentTrimmed();
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Trying to resolve class '" + string + "'");
                    }
                    Class.forName(string);
                }
                catch (Exception exception) {
                    LOGGER.error("Failed to resolve class '" + string + "'");
                    throw exception;
                }
            }
        }
    }

    public static void validateHTMLConfiguration() throws IllegalStateException {
        PhotonCSS.readCSSIncludesForGlobal((IReadableResource)new ClassPathResource("html/css.xml"));
        PhotonJS.readJSIncludesForGlobal((IReadableResource)new ClassPathResource("html/js.xml"));
    }

    public static void validateExternalResources() throws Exception {
        PhotonCoreWebAppTestRule photonCoreWebAppTestRule = new PhotonCoreWebAppTestRule();
        photonCoreWebAppTestRule.before();
        try {
            PhotonCoreValidator.validateWebXML();
            PhotonCoreValidator.validateHTMLConfiguration();
        }
        finally {
            photonCoreWebAppTestRule.after();
        }
    }
}

