/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.mgr;

import com.helger.annotation.style.UsedViaReflection;
import com.helger.base.exception.InitializationException;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.photon.core.go.GoMappingManager;
import com.helger.photon.core.smtp.FailedMailQueueWithDAO;
import com.helger.photon.core.smtp.NamedSMTPSettingsManager;
import com.helger.scope.IScope;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import com.helger.smtp.failed.FailedMailQueue;
import com.helger.smtp.scope.ScopedMailAPI;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PhotonCoreManager
extends AbstractGlobalSingleton {
    public static final String DIRECTORY_AUDITS = "audits/";
    public static final String FAILED_MAILS_XML = "failedmails.xml";
    public static final String GO_XML = "go.xml";
    public static final String SMTP_SETTINGS_XML = "smtpsettings.xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotonCoreManager.class);
    private FailedMailQueueWithDAO m_aFailedMailQueue;
    private GoMappingManager m_aGoMappingMgr;
    private NamedSMTPSettingsManager m_aSMTPSettingsMgr;

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public PhotonCoreManager() {
    }

    protected void onAfterInstantiation(@Nonnull IScope iScope) {
        try {
            this.m_aSMTPSettingsMgr = new NamedSMTPSettingsManager(SMTP_SETTINGS_XML);
            this.m_aFailedMailQueue = new FailedMailQueueWithDAO(FAILED_MAILS_XML);
            ScopedMailAPI.getInstance().setFailedMailQueue((FailedMailQueue)this.m_aFailedMailQueue);
            this.m_aGoMappingMgr = new GoMappingManager(GO_XML);
            LOGGER.info(ClassHelper.getClassLocalName((Object)((Object)this)) + " was initialized");
        }
        catch (Exception exception) {
            throw new InitializationException("Failed to init " + ClassHelper.getClassLocalName((Object)((Object)this)), (Throwable)exception);
        }
    }

    @Nonnull
    public static PhotonCoreManager getInstance() {
        return (PhotonCoreManager)PhotonCoreManager.getGlobalSingleton(PhotonCoreManager.class);
    }

    @Nonnull
    public static NamedSMTPSettingsManager getSMTPSettingsMgr() {
        return PhotonCoreManager.getInstance().m_aSMTPSettingsMgr;
    }

    @Nonnull
    public static FailedMailQueueWithDAO getFailedMailQueue() {
        return PhotonCoreManager.getInstance().m_aFailedMailQueue;
    }

    @Nonnull
    public static GoMappingManager getGoMappingMgr() {
        return PhotonCoreManager.getInstance().m_aGoMappingMgr;
    }
}

