/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.menu.ui;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.hierarchy.visit.DefaultHierarchyVisitorCallback;
import com.helger.collection.hierarchy.visit.EHierarchyVisitorReturn;
import com.helger.collection.stack.NonBlockingStack;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.grouping.HCLI;
import com.helger.html.hc.html.grouping.IHCLI;
import com.helger.html.hc.html.grouping.IHCList;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.core.execcontext.ISimpleWebExecutionContext;
import com.helger.photon.core.menu.IMenuItemExternal;
import com.helger.photon.core.menu.IMenuItemPage;
import com.helger.photon.core.menu.IMenuItemRedirectToPage;
import com.helger.photon.core.menu.IMenuObject;
import com.helger.photon.core.menu.IMenuSeparator;
import com.helger.photon.core.menu.IMenuTree;
import com.helger.photon.core.menu.MenuItemDeterminatorCallback;
import com.helger.photon.core.menu.ui.IMenuItemRenderer;
import com.helger.tree.util.TreeVisitor;
import com.helger.tree.withid.DefaultTreeItemWithID;
import jakarta.annotation.Nonnull;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class MenuRendererCallback<T extends IHCList<?, HCLI>>
extends DefaultHierarchyVisitorCallback<DefaultTreeItemWithID<String, IMenuObject>> {
    private final ISimpleWebExecutionContext m_aSWEC;
    private final Supplier<T> m_aFactory;
    private final NonBlockingStack<T> m_aMenuListStack;
    private final IMenuItemRenderer<T> m_aRenderer;
    private final ICommonsMap<String, Boolean> m_aDisplayMenuItemIDs;
    private final NonBlockingStack<HCLI> m_aMenuItemStack = new NonBlockingStack();
    private final NonBlockingStack<AtomicInteger> m_aChildCountStack = new NonBlockingStack();
    private final NonBlockingStack<DefaultTreeItemWithID<String, IMenuObject>> m_aTreeItemStack = new NonBlockingStack();
    private final String m_sSelectedItem;

    protected MenuRendererCallback(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull Supplier<T> supplier, @Nonnull NonBlockingStack<T> nonBlockingStack, @Nonnull IMenuItemRenderer<T> iMenuItemRenderer, @Nonnull ICommonsMap<String, Boolean> iCommonsMap) {
        ValueEnforcer.notNull((Object)iLayoutExecutionContext, (String)"LEC");
        ValueEnforcer.notNull(nonBlockingStack, (String)"MenuListStack");
        ValueEnforcer.notNull(iMenuItemRenderer, (String)"Renderer");
        ValueEnforcer.notNull(iCommonsMap, (String)"DisplayMenuItemIDs");
        this.m_aSWEC = iLayoutExecutionContext;
        this.m_aFactory = supplier;
        this.m_aMenuListStack = nonBlockingStack;
        this.m_aRenderer = iMenuItemRenderer;
        this.m_aDisplayMenuItemIDs = iCommonsMap;
        this.m_aChildCountStack.push((Object)new AtomicInteger(0));
        this.m_sSelectedItem = iLayoutExecutionContext.getSelectedMenuItemID();
    }

    public final void onLevelDown() {
        super.onLevelDown();
        DefaultTreeItemWithID defaultTreeItemWithID = (DefaultTreeItemWithID)this.m_aTreeItemStack.peek();
        for (DefaultTreeItemWithID defaultTreeItemWithID2 : defaultTreeItemWithID.getAllChildren()) {
            if (!this.m_aDisplayMenuItemIDs.containsKey(defaultTreeItemWithID2.getID())) continue;
            IHCList iHCList = (IHCList)this.m_aFactory.get();
            this.m_aRenderer.onLevelDown(iHCList);
            this.m_aMenuListStack.push((Object)((IHCList)((HCLI)this.m_aMenuItemStack.peek()).addAndReturnChild((IHCNode)iHCList)));
            break;
        }
        this.m_aChildCountStack.push((Object)new AtomicInteger(0));
    }

    public final void onLevelUp() {
        AtomicInteger atomicInteger = (AtomicInteger)this.m_aChildCountStack.pop();
        if (atomicInteger.intValue() > 0) {
            IHCList iHCList = (IHCList)this.m_aMenuListStack.pop();
            this.m_aRenderer.onLevelUp(iHCList);
        }
        super.onLevelUp();
    }

    public final EHierarchyVisitorReturn onItemBeforeChildren(@Nonnull DefaultTreeItemWithID<String, IMenuObject> defaultTreeItemWithID) {
        this.m_aTreeItemStack.push(defaultTreeItemWithID);
        Boolean bl = (Boolean)this.m_aDisplayMenuItemIDs.get(defaultTreeItemWithID.getID());
        if (bl != null) {
            boolean bl2;
            IHCList iHCList = (IHCList)this.m_aMenuListStack.peek();
            IMenuObject iMenuObject = (IMenuObject)defaultTreeItemWithID.getData();
            boolean bl3 = defaultTreeItemWithID.hasChildren();
            if (bl3) {
                bl2 = false;
                for (IMenuObject iMenuObject2 : defaultTreeItemWithID.getAllChildDatas()) {
                    if (!this.m_aDisplayMenuItemIDs.containsKey(iMenuObject2.getID())) continue;
                    bl2 = true;
                    break;
                }
                bl3 = bl2;
            }
            if (iMenuObject instanceof IMenuSeparator) {
                IHCNode iHCNode = this.m_aRenderer.renderSeparator(this.m_aSWEC, (IMenuSeparator)iMenuObject);
                Iterator iterator = iHCNode instanceof HCLI ? (HCLI)iHCList.addAndReturnItem((IHCLI)((HCLI)iHCNode)) : (HCLI)iHCList.addAndReturnItem(iHCNode);
                this.m_aRenderer.onMenuSeparatorItem(this.m_aSWEC, (HCLI)iterator);
                this.m_aMenuItemStack.push((Object)iterator);
            } else {
                bl2 = bl;
                boolean bl4 = ((String)iMenuObject.getID()).equals(this.m_sSelectedItem);
                if (iMenuObject instanceof IMenuItemPage) {
                    iMenuObject2 = this.m_aRenderer.renderMenuItemPage(this.m_aSWEC, (IMenuItemPage)iMenuObject, bl3, bl4, bl2);
                    HCLI hCLI = iMenuObject2 instanceof HCLI ? (HCLI)iHCList.addAndReturnItem((IHCLI)((HCLI)iMenuObject2)) : (HCLI)iHCList.addAndReturnItem((IHCNode)iMenuObject2);
                    this.m_aRenderer.onMenuItemPageItem(this.m_aSWEC, hCLI, bl3, bl4, bl2);
                    this.m_aMenuItemStack.push((Object)hCLI);
                } else if (iMenuObject instanceof IMenuItemExternal) {
                    iMenuObject2 = this.m_aRenderer.renderMenuItemExternal(this.m_aSWEC, (IMenuItemExternal)iMenuObject, bl3, bl4, bl2);
                    HCLI hCLI = iMenuObject2 instanceof HCLI ? (HCLI)iHCList.addAndReturnItem((IHCLI)((HCLI)iMenuObject2)) : (HCLI)iHCList.addAndReturnItem((IHCNode)iMenuObject2);
                    this.m_aRenderer.onMenuItemExternalItem(this.m_aSWEC, hCLI, bl3, bl4, bl2);
                    this.m_aMenuItemStack.push((Object)hCLI);
                } else {
                    if (iMenuObject instanceof IMenuItemRedirectToPage) {
                        this.m_aMenuItemStack.push((Object)new HCLI());
                        return EHierarchyVisitorReturn.USE_NEXT_SIBLING;
                    }
                    throw new IllegalStateException("Unsupported menu object type: " + String.valueOf(iMenuObject));
                }
            }
            ((AtomicInteger)this.m_aChildCountStack.peek()).incrementAndGet();
            return EHierarchyVisitorReturn.CONTINUE;
        }
        this.m_aMenuItemStack.push((Object)new HCLI());
        return EHierarchyVisitorReturn.USE_NEXT_SIBLING;
    }

    @Nonnull
    public final EHierarchyVisitorReturn onItemAfterChildren(DefaultTreeItemWithID<String, IMenuObject> defaultTreeItemWithID) {
        this.m_aTreeItemStack.pop();
        this.m_aMenuItemStack.pop();
        return EHierarchyVisitorReturn.CONTINUE;
    }

    @Nonnull
    public static <T extends IHCList<T, HCLI>> T createRenderedMenu(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull Supplier<T> supplier, @Nonnull IMenuItemRenderer<T> iMenuItemRenderer) {
        IMenuTree iMenuTree = iLayoutExecutionContext.getMenuTree();
        return MenuRendererCallback.createRenderedMenu(iLayoutExecutionContext, supplier, (DefaultTreeItemWithID<String, IMenuObject>)((DefaultTreeItemWithID)iMenuTree.getRootItem()), iMenuItemRenderer, MenuItemDeterminatorCallback.getAllDisplayMenuItemIDs(iMenuTree, iLayoutExecutionContext.getSelectedMenuItemID()));
    }

    @Nonnull
    public static <T extends IHCList<T, HCLI>> T createRenderedMenu(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull Supplier<T> supplier, @Nonnull DefaultTreeItemWithID<String, IMenuObject> defaultTreeItemWithID, @Nonnull IMenuItemRenderer<T> iMenuItemRenderer) {
        IMenuTree iMenuTree = iLayoutExecutionContext.getMenuTree();
        return MenuRendererCallback.createRenderedMenu(iLayoutExecutionContext, supplier, defaultTreeItemWithID, iMenuItemRenderer, MenuItemDeterminatorCallback.getAllDisplayMenuItemIDs(iMenuTree, iLayoutExecutionContext.getSelectedMenuItemID()));
    }

    @Nonnull
    public static <T extends IHCList<T, HCLI>> T createRenderedMenu(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull Supplier<T> supplier, @Nonnull IMenuItemRenderer<T> iMenuItemRenderer, @Nonnull ICommonsMap<String, Boolean> iCommonsMap) {
        return MenuRendererCallback.createRenderedMenu(iLayoutExecutionContext, supplier, (DefaultTreeItemWithID<String, IMenuObject>)((DefaultTreeItemWithID)iLayoutExecutionContext.getMenuTree().getRootItem()), iMenuItemRenderer, iCommonsMap);
    }

    @Nonnull
    public static <T extends IHCList<T, HCLI>> T createRenderedMenu(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull Supplier<T> supplier, @Nonnull DefaultTreeItemWithID<String, IMenuObject> defaultTreeItemWithID, @Nonnull IMenuItemRenderer<T> iMenuItemRenderer, @Nonnull ICommonsMap<String, Boolean> iCommonsMap) {
        ValueEnforcer.notNull(supplier, (String)"Factory");
        NonBlockingStack nonBlockingStack = new NonBlockingStack();
        nonBlockingStack.push((Object)((IHCList)supplier.get()));
        TreeVisitor.visitTreeItem(defaultTreeItemWithID, new MenuRendererCallback<T>(iLayoutExecutionContext, supplier, nonBlockingStack, iMenuItemRenderer, iCommonsMap));
        if (nonBlockingStack.size() != 1) {
            throw new IllegalStateException("Stack is inconsistent: " + String.valueOf(nonBlockingStack));
        }
        return (T)((IHCList)nonBlockingStack.pop());
    }
}

