/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.menu.ui;

import com.helger.html.css.DefaultCSSClassProvider;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.HC_Target;
import com.helger.html.hc.html.grouping.HCLI;
import com.helger.html.hc.html.grouping.IHCList;
import com.helger.html.hc.html.textlevel.HCA;
import com.helger.html.hc.impl.HCEntityNode;
import com.helger.photon.core.execcontext.ISimpleWebExecutionContext;
import com.helger.photon.core.menu.IMenuItemExternal;
import com.helger.photon.core.menu.IMenuItemPage;
import com.helger.photon.core.menu.IMenuSeparator;
import com.helger.photon.core.menu.ui.AbstractMenuItemRenderer;
import com.helger.url.ISimpleURL;
import jakarta.annotation.Nonnull;
import java.util.Locale;

public class DefaultMenuItemRenderer<T extends IHCList<?, HCLI>>
extends AbstractMenuItemRenderer<T> {
    public static final ICSSClassProvider CSS_CLASS_MENU_SEPARATOR = DefaultCSSClassProvider.create((String)"menu_separator");
    public static final ICSSClassProvider CSS_CLASS_MENU_ITEM = DefaultCSSClassProvider.create((String)"menu_item");
    public static final ICSSClassProvider CSS_CLASS_MENU_ITEM_EXTERNAL = DefaultCSSClassProvider.create((String)"menu_item_external");
    public static final ICSSClassProvider CSS_CLASS_SELECTED_MENU_ITEM = DefaultCSSClassProvider.create((String)"selected_menu_item");
    public static final String CSS_ID_PREFIX_MENU_ITEM = "menu_item_";

    public DefaultMenuItemRenderer(@Nonnull Locale locale) {
        super(locale);
    }

    @Override
    @Nonnull
    public IHCNode renderSeparator(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext, @Nonnull IMenuSeparator iMenuSeparator) {
        return HCEntityNode.newNBSP();
    }

    @Override
    @Nonnull
    public IHCNode renderMenuItemPage(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext, @Nonnull IMenuItemPage iMenuItemPage, boolean bl, boolean bl2, boolean bl3) {
        String string = (String)iMenuItemPage.getID();
        HCA hCA = new HCA((ISimpleURL)iSimpleWebExecutionContext.getLinkToMenuItem(string));
        hCA.addChild(iMenuItemPage.getDisplayText(this.getContentLocale()) + (bl && !bl3 ? " [+]" : ""));
        hCA.setID(CSS_ID_PREFIX_MENU_ITEM + string);
        if (bl2) {
            hCA.addClass(CSS_CLASS_SELECTED_MENU_ITEM);
        }
        return hCA;
    }

    @Override
    @Nonnull
    public IHCNode renderMenuItemExternal(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext, @Nonnull IMenuItemExternal iMenuItemExternal, boolean bl, boolean bl2, boolean bl3) {
        String string = (String)iMenuItemExternal.getID();
        HCA hCA = new HCA(iMenuItemExternal.getURL());
        hCA.setTarget(HC_Target.BLANK);
        hCA.addChild(iMenuItemExternal.getDisplayText(this.getContentLocale()) + (bl && !bl3 ? " [+]" : ""));
        hCA.setID(CSS_ID_PREFIX_MENU_ITEM + string);
        if (bl2) {
            hCA.addClass(CSS_CLASS_SELECTED_MENU_ITEM);
        }
        return hCA;
    }

    @Override
    public void onMenuSeparatorItem(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext, @Nonnull HCLI hCLI) {
        hCLI.addClass(CSS_CLASS_MENU_SEPARATOR);
    }

    @Override
    public void onMenuItemPageItem(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext, @Nonnull HCLI hCLI, boolean bl, boolean bl2, boolean bl3) {
        hCLI.addClass(CSS_CLASS_MENU_ITEM);
    }

    @Override
    public void onMenuItemExternalItem(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext, @Nonnull HCLI hCLI, boolean bl, boolean bl2, boolean bl3) {
        hCLI.addClass(CSS_CLASS_MENU_ITEM_EXTERNAL);
    }
}

