/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.menu.filter;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.menu.IMenuObject;
import com.helger.photon.core.menu.filter.AbstractMenuObjectFilter;
import com.helger.photon.security.util.SecurityHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

@NotThreadSafe
public class MenuObjectFilterUserHasRole
extends AbstractMenuObjectFilter {
    private final String m_sRoleID;

    public MenuObjectFilterUserHasRole(@Nonnull @Nonempty String string) {
        this.m_sRoleID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"RoleID");
    }

    @Nonnull
    @Nonempty
    public String getRoleID() {
        return this.m_sRoleID;
    }

    @Override
    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return EPhotonCoreText.MENU_OBJECT_FILTER_USER_HAS_ROLE.getDisplayTextWithArgs(locale, new Object[]{this.m_sRoleID});
    }

    @Override
    public boolean test(@Nullable IMenuObject iMenuObject) {
        return SecurityHelper.hasCurrentUserRole((String)this.m_sRoleID);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("roleID", (Object)this.m_sRoleID).getToString();
    }
}

