/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.menu.filter;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.menu.IMenuObject;
import com.helger.photon.core.menu.filter.AbstractMenuObjectFilter;
import com.helger.photon.security.util.SecurityHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

@NotThreadSafe
public class MenuObjectFilterUserAssignedToUserGroup
extends AbstractMenuObjectFilter {
    private final String m_sUserGroupID;

    public MenuObjectFilterUserAssignedToUserGroup(@Nonnull @Nonempty String string) {
        this.m_sUserGroupID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"UserGroupID");
    }

    @Nonnull
    @Nonempty
    public String getUserGroupID() {
        return this.m_sUserGroupID;
    }

    @Override
    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return EPhotonCoreText.MENU_OBJECT_FILTER_USER_ASSIGNED_TO_GROUP.getDisplayTextWithArgs(locale, new Object[]{this.m_sUserGroupID});
    }

    @Override
    public boolean test(@Nullable IMenuObject iMenuObject) {
        return SecurityHelper.isCurrentUserAssignedToUserGroup((String)this.m_sUserGroupID);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("userGroupID", (Object)this.m_sUserGroupID).getToString();
    }
}

