/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.menu;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.hierarchy.visit.DefaultHierarchyVisitorCallback;
import com.helger.collection.hierarchy.visit.EHierarchyVisitorReturn;
import com.helger.collection.hierarchy.visit.IHierarchyVisitorCallback;
import com.helger.photon.core.menu.IMenuItemExternal;
import com.helger.photon.core.menu.IMenuItemPage;
import com.helger.photon.core.menu.IMenuItemRedirectToPage;
import com.helger.photon.core.menu.IMenuObject;
import com.helger.photon.core.menu.IMenuSeparator;
import com.helger.photon.core.menu.IMenuTree;
import com.helger.photon.core.menu.MenuItemExternal;
import com.helger.photon.core.menu.MenuItemPage;
import com.helger.photon.core.menu.MenuItemRedirectToPage;
import com.helger.photon.core.menu.MenuSeparator;
import com.helger.photon.core.page.IPage;
import com.helger.text.display.IHasDisplayText;
import com.helger.tree.IBasicTree;
import com.helger.tree.util.TreeVisitor;
import com.helger.tree.withid.DefaultTreeItemWithID;
import com.helger.tree.withid.unique.DefaultTreeWithGlobalUniqueID;
import com.helger.url.provider.IHasSimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuTree
extends DefaultTreeWithGlobalUniqueID<String, IMenuObject>
implements IMenuTree {
    private static final Logger LOGGER = LoggerFactory.getLogger(MenuTree.class);
    private final ICommonsList<String> m_aDefaultMenuItemIDs = new CommonsArrayList();

    @Nonnull
    protected static <T extends IMenuObject> T internalCreateChildItem(@Nonnull DefaultTreeItemWithID<String, IMenuObject> defaultTreeItemWithID, @Nonnull T t) {
        if (defaultTreeItemWithID.createChildItem((Object)((String)t.getID()), t, false) == null) {
            throw new IllegalArgumentException("Failed to add the menu object " + String.valueOf(t) + " probably the ID is already contained!");
        }
        return t;
    }

    @Override
    @Nonnull
    public IMenuSeparator createRootSeparator(@Nonnull @Nonempty String string) {
        return MenuTree.internalCreateChildItem((DefaultTreeItemWithID<String, IMenuObject>)((DefaultTreeItemWithID)this.getRootItem()), new MenuSeparator(string));
    }

    @Override
    @Nonnull
    public IMenuSeparator createSeparator(@Nonnull String string, @Nonnull @Nonempty String string2) {
        DefaultTreeItemWithID defaultTreeItemWithID = (DefaultTreeItemWithID)this.getItemWithID(string);
        if (defaultTreeItemWithID == null) {
            throw new IllegalArgumentException("No such parent menu item '" + string + "'");
        }
        return MenuTree.internalCreateChildItem((DefaultTreeItemWithID<String, IMenuObject>)defaultTreeItemWithID, new MenuSeparator(string2));
    }

    @Override
    @Nonnull
    public IMenuItemPage createRootItem(@Nonnull String string, @Nonnull IPage iPage) {
        return MenuTree.internalCreateChildItem((DefaultTreeItemWithID<String, IMenuObject>)((DefaultTreeItemWithID)this.getRootItem()), new MenuItemPage(string, iPage));
    }

    @Override
    @Nonnull
    public IMenuItemPage createItem(@Nonnull String string, @Nonnull String string2, @Nonnull IPage iPage) {
        DefaultTreeItemWithID defaultTreeItemWithID = (DefaultTreeItemWithID)this.getItemWithID(string);
        if (defaultTreeItemWithID == null) {
            throw new IllegalArgumentException("No such parent menu item '" + string + "'");
        }
        return MenuTree.internalCreateChildItem((DefaultTreeItemWithID<String, IMenuObject>)defaultTreeItemWithID, new MenuItemPage(string2, iPage));
    }

    @Override
    @Nonnull
    public IMenuItemExternal createRootItem(@Nonnull String string, @Nonnull IHasSimpleURL iHasSimpleURL, @Nonnull IHasDisplayText iHasDisplayText) {
        return MenuTree.internalCreateChildItem((DefaultTreeItemWithID<String, IMenuObject>)((DefaultTreeItemWithID)this.getRootItem()), new MenuItemExternal(string, iHasSimpleURL, iHasDisplayText));
    }

    @Override
    @Nonnull
    public IMenuItemExternal createItem(@Nonnull String string, @Nonnull String string2, @Nonnull IHasSimpleURL iHasSimpleURL, @Nonnull IHasDisplayText iHasDisplayText) {
        DefaultTreeItemWithID defaultTreeItemWithID = (DefaultTreeItemWithID)this.getItemWithID(string);
        if (defaultTreeItemWithID == null) {
            throw new IllegalArgumentException("No such parent menu item '" + string + "'");
        }
        return MenuTree.internalCreateChildItem((DefaultTreeItemWithID<String, IMenuObject>)defaultTreeItemWithID, new MenuItemExternal(string2, iHasSimpleURL, iHasDisplayText));
    }

    @Override
    @Nonnull
    public IMenuItemRedirectToPage createRedirect(@Nonnull String string, @Nonnull IMenuItemPage iMenuItemPage) {
        return MenuTree.internalCreateChildItem((DefaultTreeItemWithID<String, IMenuObject>)((DefaultTreeItemWithID)this.getRootItem()), new MenuItemRedirectToPage(string, iMenuItemPage));
    }

    @Override
    public void setDefaultMenuItemID(@Nullable String string) {
        if (string == null) {
            this.m_aDefaultMenuItemIDs.clear();
        } else {
            this.m_aDefaultMenuItemIDs.set((Object)string);
        }
    }

    @Override
    public void setDefaultMenuItemIDs(String ... stringArray) {
        this.m_aDefaultMenuItemIDs.setAll((Object[])stringArray);
    }

    @Override
    public void setDefaultMenuItemIDs(@Nullable Iterable<String> iterable) {
        this.m_aDefaultMenuItemIDs.setAll(iterable);
    }

    @Override
    @Nullable
    public String getDefaultMenuItemID() {
        return (String)this.m_aDefaultMenuItemIDs.getFirstOrNull();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllDefaultMenuItemIDs() {
        return (ICommonsList)this.m_aDefaultMenuItemIDs.getClone();
    }

    @Nullable
    private IMenuItemPage _getDefaultMenuItem(@Nullable String string) {
        if (string != null) {
            DefaultTreeItemWithID defaultTreeItemWithID = (DefaultTreeItemWithID)this.getItemWithID(string);
            if (defaultTreeItemWithID != null) {
                IMenuObject iMenuObject = (IMenuObject)defaultTreeItemWithID.getData();
                if (iMenuObject instanceof IMenuItemPage) {
                    return (IMenuItemPage)iMenuObject;
                }
                LOGGER.warn("The default menu object ID '" + string + "' does not resolve to an IMenuItemPage but to " + ClassHelper.getSafeClassName((Object)iMenuObject));
            } else {
                LOGGER.warn("Failed to resolve the default menu item ID '" + string + "'");
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IMenuItemPage getDefaultMenuItem() {
        return this._getDefaultMenuItem(this.getDefaultMenuItemID());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMenuItemPage> getAllDefaultMenuItems() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (this.m_aDefaultMenuItemIDs != null) {
            for (String string : this.m_aDefaultMenuItemIDs) {
                IMenuItemPage iMenuItemPage = this._getDefaultMenuItem(string);
                if (iMenuItemPage == null) continue;
                commonsArrayList.add((Object)iMenuItemPage);
            }
        }
        return commonsArrayList;
    }

    @Override
    @Nullable
    public IMenuObject getMenuObjectOfID(@Nullable String string) {
        return (IMenuObject)this.getItemDataWithID(string);
    }

    @Override
    public void iterateAllMenuObjects(final @Nonnull Consumer<? super IMenuObject> consumer) {
        ValueEnforcer.notNull(consumer, (String)"Callback");
        TreeVisitor.visitTree((IBasicTree)this, (IHierarchyVisitorCallback)new DefaultHierarchyVisitorCallback<DefaultTreeItemWithID<String, IMenuObject>>(){

            public EHierarchyVisitorReturn onItemBeforeChildren(@Nonnull DefaultTreeItemWithID<String, IMenuObject> defaultTreeItemWithID) {
                consumer.accept(defaultTreeItemWithID.getData());
                return EHierarchyVisitorReturn.CONTINUE;
            }
        });
    }

    @Override
    @Nullable
    public IMenuItemPage replaceMenuItem(@Nonnull IPage iPage) {
        ValueEnforcer.notNull((Object)iPage, (String)"NewPage");
        String string = (String)iPage.getID();
        DefaultTreeItemWithID defaultTreeItemWithID = (DefaultTreeItemWithID)this.getItemWithID(string);
        if (defaultTreeItemWithID == null) {
            return null;
        }
        MenuItemPage menuItemPage = new MenuItemPage(string, iPage);
        defaultTreeItemWithID.setData((Object)menuItemPage);
        return menuItemPage;
    }

    @Override
    @Nullable
    public DefaultTreeItemWithID<String, IMenuObject> getRootItemOfItemWithID(@Nullable String string) {
        DefaultTreeItemWithID defaultTreeItemWithID = (DefaultTreeItemWithID)this.getItemWithID(string);
        if (defaultTreeItemWithID == null || defaultTreeItemWithID.isRootItem()) {
            return null;
        }
        DefaultTreeItemWithID defaultTreeItemWithID2 = defaultTreeItemWithID;
        while (!((DefaultTreeItemWithID)defaultTreeItemWithID2.getParent()).isRootItem()) {
            defaultTreeItemWithID2 = (DefaultTreeItemWithID)defaultTreeItemWithID2.getParent();
        }
        return defaultTreeItemWithID2;
    }

    @Override
    @Nullable
    public IMenuObject getRootItemDataOfItemWithID(@Nullable String string) {
        DefaultTreeItemWithID<String, IMenuObject> defaultTreeItemWithID = this.getRootItemOfItemWithID(string);
        return defaultTreeItemWithID == null ? null : (IMenuObject)defaultTreeItemWithID.getData();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        MenuTree menuTree = (MenuTree)object;
        return EqualsHelper.equals(this.m_aDefaultMenuItemIDs, menuTree.m_aDefaultMenuItemIDs);
    }

    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_aDefaultMenuItemIDs).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("DefaultMenuItemIDs", this.m_aDefaultMenuItemIDs).getToString();
    }
}

