/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.menu;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.photon.core.menu.AbstractMenuObject;
import com.helger.photon.core.menu.EMenuObjectType;
import com.helger.photon.core.menu.IMenuItemPage;
import com.helger.photon.core.menu.IMenuItemRedirectToPage;
import jakarta.annotation.Nonnull;

@NotThreadSafe
public class MenuItemRedirectToPage
extends AbstractMenuObject<MenuItemRedirectToPage>
implements IMenuItemRedirectToPage {
    private final IMenuItemPage m_aMenuItemPage;

    public MenuItemRedirectToPage(@Nonnull @Nonempty String string, @Nonnull IMenuItemPage iMenuItemPage) {
        super(string);
        this.m_aMenuItemPage = (IMenuItemPage)ValueEnforcer.notNull((Object)iMenuItemPage, (String)"MenuItemPage");
    }

    @Override
    @Nonnull
    public final EMenuObjectType getMenuObjectType() {
        return EMenuObjectType.REDIRECT_TO_PAGE;
    }

    @Override
    @Nonnull
    public IMenuItemPage getTargetMenuItemPage() {
        return this.m_aMenuItemPage;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        MenuItemRedirectToPage menuItemRedirectToPage = (MenuItemRedirectToPage)object;
        return ((String)this.m_aMenuItemPage.getID()).equals(menuItemRedirectToPage.m_aMenuItemPage.getID());
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aMenuItemPage).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("MenuItemPage", (Object)this.m_aMenuItemPage).getToString();
    }
}

