/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.menu;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.photon.core.menu.AbstractMenuObject;
import com.helger.photon.core.menu.EMenuObjectType;
import com.helger.photon.core.menu.IMenuItemPage;
import com.helger.photon.core.page.IPage;
import com.helger.text.display.IHasDisplayText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

@NotThreadSafe
public class MenuItemPage
extends AbstractMenuObject<MenuItemPage>
implements IMenuItemPage {
    private final IPage m_aPage;
    private final IHasDisplayText m_aDisplayText;
    private String m_sTarget;

    public MenuItemPage(@Nonnull @Nonempty String string, @Nonnull IPage iPage) {
        this(string, iPage, iPage);
    }

    public MenuItemPage(@Nonnull @Nonempty String string, @Nonnull IPage iPage, @Nonnull IHasDisplayText iHasDisplayText) {
        super(string);
        this.m_aPage = (IPage)ValueEnforcer.notNull((Object)iPage, (String)"Page");
        this.m_aDisplayText = (IHasDisplayText)ValueEnforcer.notNull((Object)iHasDisplayText, (String)"DisplayText");
    }

    @Override
    @Nonnull
    public final EMenuObjectType getMenuObjectType() {
        return EMenuObjectType.PAGE;
    }

    @Override
    @Nonnull
    public IPage getPage() {
        return this.m_aPage;
    }

    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_aDisplayText.getDisplayText(locale);
    }

    @Override
    @Nullable
    public String getTarget() {
        return this.m_sTarget;
    }

    @Override
    @Nonnull
    public MenuItemPage setTarget(@Nullable String string) {
        this.m_sTarget = string;
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        MenuItemPage menuItemPage = (MenuItemPage)object;
        return ((String)this.m_aPage.getID()).equals(menuItemPage.m_aPage.getID());
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aPage).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Page", (Object)this.m_aPage).append("DisplayText", (Object)this.m_aDisplayText).append("Target", (Object)this.m_sTarget).getToString();
    }
}

