/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.menu;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.photon.core.menu.AbstractMenuObject;
import com.helger.photon.core.menu.EMenuObjectType;
import com.helger.photon.core.menu.IMenuItemExternal;
import com.helger.text.display.IHasDisplayText;
import com.helger.url.provider.IHasSimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

@NotThreadSafe
public class MenuItemExternal
extends AbstractMenuObject<MenuItemExternal>
implements IMenuItemExternal {
    private final IHasSimpleURL m_aURLProvider;
    private final IHasDisplayText m_aDisplayText;
    private String m_sTarget;

    public MenuItemExternal(@Nonnull @Nonempty String string, @Nonnull IHasSimpleURL iHasSimpleURL, @Nonnull IHasDisplayText iHasDisplayText) {
        super(string);
        this.m_aURLProvider = (IHasSimpleURL)ValueEnforcer.notNull((Object)iHasSimpleURL, (String)"URL");
        this.m_aDisplayText = (IHasDisplayText)ValueEnforcer.notNull((Object)iHasDisplayText, (String)"DisplayText");
    }

    @Override
    @Nonnull
    public final EMenuObjectType getMenuObjectType() {
        return EMenuObjectType.EXTERNAL;
    }

    @Override
    @Nonnull
    public final IHasSimpleURL getURLProvider() {
        return this.m_aURLProvider;
    }

    @Nullable
    public final String getDisplayText(@Nonnull Locale locale) {
        return this.m_aDisplayText.getDisplayText(locale);
    }

    @Override
    @Nullable
    public final String getTarget() {
        return this.m_sTarget;
    }

    @Override
    @Nonnull
    public final MenuItemExternal setTarget(@Nullable String string) {
        this.m_sTarget = string;
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        MenuItemExternal menuItemExternal = (MenuItemExternal)object;
        return this.m_aURLProvider.equals((Object)menuItemExternal.m_aURLProvider);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aURLProvider).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("URLProvider", (Object)this.m_aURLProvider).append("DisplayText", (Object)this.m_aDisplayText).append("Target", (Object)this.m_sTarget).getToString();
    }
}

