/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.menu;

import com.helger.annotation.Nonempty;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.hierarchy.visit.DefaultHierarchyVisitorCallback;
import com.helger.collection.hierarchy.visit.EHierarchyVisitorReturn;
import com.helger.collection.hierarchy.visit.IHierarchyVisitorCallback;
import com.helger.photon.core.menu.AbstractMenuItemDeterminatorCallback;
import com.helger.photon.core.menu.IMenuItemDeterminatorCallback;
import com.helger.photon.core.menu.IMenuObject;
import com.helger.photon.core.menu.IMenuTree;
import com.helger.tree.IBasicTree;
import com.helger.tree.util.TreeVisitor;
import com.helger.tree.withid.DefaultTreeItemWithID;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class MenuItemDeterminatorCallback
extends AbstractMenuItemDeterminatorCallback {
    private final ICommonsMap<String, Boolean> m_aItems = new CommonsHashMap();
    private final String m_sSelectedItemID;
    private final DefaultTreeItemWithID<String, IMenuObject> m_aSelectedItem;

    public MenuItemDeterminatorCallback(@Nonnull IMenuTree iMenuTree, @Nullable String string) {
        super(iMenuTree);
        this.m_sSelectedItemID = string;
        this.m_aSelectedItem = (DefaultTreeItemWithID)iMenuTree.getItemWithID(this.m_sSelectedItemID);
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected boolean isMenuItemValidToBeDisplayed(@Nonnull IMenuObject iMenuObject) {
        return iMenuObject.matchesDisplayFilter();
    }

    @OverrideOnDemand
    protected void rememberMenuItemForDisplay(@Nonnull @Nonempty String string, boolean bl) {
        Boolean bl2 = (Boolean)this.m_aItems.get((Object)string);
        if (bl2 == null || !bl2.booleanValue()) {
            this.m_aItems.put((Object)string, (Object)bl);
        }
    }

    public final EHierarchyVisitorReturn onItemBeforeChildren(@Nonnull DefaultTreeItemWithID<String, IMenuObject> defaultTreeItemWithID2) {
        boolean bl;
        boolean bl2;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = bl2 = this.getLevel() == 0;
        if (this.m_aSelectedItem == null) {
            bl = bl2;
        } else if (bl2) {
            bl = true;
            bl4 = this.m_aSelectedItem.isSameOrChildOf(defaultTreeItemWithID2);
        } else {
            if (this.m_aSelectedItem.isSameOrChildOf(defaultTreeItemWithID2)) {
                bl = true;
                bl4 = true;
            } else {
                DefaultTreeItemWithID defaultTreeItemWithID3 = (DefaultTreeItemWithID)defaultTreeItemWithID2.getParent();
                bl = defaultTreeItemWithID3.equals(this.m_aSelectedItem) ? true : defaultTreeItemWithID3.getChildItemOfDataID((Object)this.m_sSelectedItemID) != null;
            }
            bl3 = bl;
        }
        if ((bl || bl3) && !this.isMenuItemValidToBeDisplayed((IMenuObject)defaultTreeItemWithID2.getData())) {
            bl = false;
            bl3 = false;
            bl4 = false;
        }
        if (bl) {
            this.rememberMenuItemForDisplay((String)defaultTreeItemWithID2.getID(), bl4);
        }
        if (bl3) {
            ((DefaultTreeItemWithID)defaultTreeItemWithID2.getParent()).forAllChildren(defaultTreeItemWithID -> this.isMenuItemValidToBeDisplayed((IMenuObject)defaultTreeItemWithID.getData()), defaultTreeItemWithID -> this.rememberMenuItemForDisplay((String)defaultTreeItemWithID.getID(), false));
        }
        return EHierarchyVisitorReturn.CONTINUE;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, Boolean> getAllItemIDs() {
        return (ICommonsMap)this.m_aItems.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<String, Boolean> getAllDisplayMenuItemIDs(@Nonnull IMenuTree iMenuTree, @Nullable String string) {
        return MenuItemDeterminatorCallback.getAllDisplayMenuItemIDs(new MenuItemDeterminatorCallback(iMenuTree, string));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<String, Boolean> getAllDisplayMenuItemIDs(@Nonnull IMenuItemDeterminatorCallback iMenuItemDeterminatorCallback) {
        ValueEnforcer.notNull((Object)iMenuItemDeterminatorCallback, (String)"Determinator");
        TreeVisitor.visitTree((IBasicTree)iMenuItemDeterminatorCallback.getMenuTree(), (IHierarchyVisitorCallback)iMenuItemDeterminatorCallback);
        return iMenuItemDeterminatorCallback.getAllItemIDs();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<String, Boolean> getAllMenuItemIDs(@Nonnull IMenuTree iMenuTree) {
        ValueEnforcer.notNull((Object)iMenuTree, (String)"MenuTree");
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        TreeVisitor.visitTree((IBasicTree)iMenuTree, (IHierarchyVisitorCallback)new DefaultHierarchyVisitorCallback<DefaultTreeItemWithID<String, IMenuObject>>((ICommonsMap)commonsHashMap){
            final /* synthetic */ ICommonsMap val$ret;
            {
                this.val$ret = iCommonsMap;
            }

            public EHierarchyVisitorReturn onItemBeforeChildren(@Nonnull DefaultTreeItemWithID<String, IMenuObject> defaultTreeItemWithID) {
                this.val$ret.put((Object)((String)defaultTreeItemWithID.getID()), (Object)defaultTreeItemWithID.hasChildren());
                return EHierarchyVisitorReturn.CONTINUE;
            }
        });
        return commonsHashMap;
    }
}

