/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.menu;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.collection.commons.ICommonsList;
import com.helger.photon.core.menu.IMenuItem;
import com.helger.photon.core.menu.IMenuItemExternal;
import com.helger.photon.core.menu.IMenuItemPage;
import com.helger.photon.core.menu.IMenuItemRedirectToPage;
import com.helger.photon.core.menu.IMenuObject;
import com.helger.photon.core.menu.IMenuSeparator;
import com.helger.photon.core.page.IPage;
import com.helger.text.display.IHasDisplayText;
import com.helger.url.ISimpleURL;
import com.helger.url.provider.ConstantHasSimpleURL;
import com.helger.url.provider.IHasSimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.function.Consumer;

public interface IMenuOperations
extends Serializable {
    @Nonnull
    @Nonempty
    public static String getUniqueMenuObjectID() {
        return GlobalIDFactory.getNewStringID();
    }

    @Nonnull
    default public IMenuSeparator createRootSeparator() {
        return this.createRootSeparator(IMenuOperations.getUniqueMenuObjectID());
    }

    @Nonnull
    public IMenuSeparator createRootSeparator(@Nonnull @Nonempty String var1);

    @Nonnull
    default public IMenuSeparator createSeparator(@Nonnull String string) {
        return this.createSeparator(string, IMenuOperations.getUniqueMenuObjectID());
    }

    @Nonnull
    default public IMenuSeparator createSeparator(@Nonnull IMenuItem iMenuItem) {
        ValueEnforcer.notNull((Object)iMenuItem, (String)"Parent");
        return this.createSeparator((String)iMenuItem.getID());
    }

    @Nonnull
    public IMenuSeparator createSeparator(@Nonnull String var1, @Nonnull @Nonempty String var2);

    @Nonnull
    default public IMenuSeparator createSeparator(@Nonnull IMenuItem iMenuItem, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull((Object)iMenuItem, (String)"Parent");
        return this.createSeparator((String)iMenuItem.getID(), string);
    }

    @Nonnull
    public IMenuItemPage createRootItem(@Nonnull String var1, @Nonnull IPage var2);

    @Nonnull
    default public IMenuItemPage createRootItem(@Nonnull IPage iPage) {
        ValueEnforcer.notNull((Object)iPage, (String)"Page");
        return this.createRootItem((String)iPage.getID(), iPage);
    }

    @Nonnull
    public IMenuItemPage createItem(@Nonnull String var1, @Nonnull String var2, @Nonnull IPage var3);

    @Nonnull
    default public IMenuItemPage createItem(@Nonnull String string, @Nonnull IPage iPage) {
        ValueEnforcer.notNull((Object)iPage, (String)"Page");
        return this.createItem(string, (String)iPage.getID(), iPage);
    }

    @Nonnull
    default public IMenuItemPage createItem(@Nonnull IMenuItem iMenuItem, @Nonnull IPage iPage) {
        ValueEnforcer.notNull((Object)iMenuItem, (String)"Parent");
        return this.createItem((String)iMenuItem.getID(), iPage);
    }

    @Nonnull
    default public IMenuItemExternal createRootItem(@Nonnull String string, @Nonnull ISimpleURL iSimpleURL, @Nonnull IHasDisplayText iHasDisplayText) {
        return this.createRootItem(string, (IHasSimpleURL)new ConstantHasSimpleURL(iSimpleURL), iHasDisplayText);
    }

    @Nonnull
    public IMenuItemExternal createRootItem(@Nonnull String var1, @Nonnull IHasSimpleURL var2, @Nonnull IHasDisplayText var3);

    @Nonnull
    default public IMenuItemExternal createItem(@Nonnull IMenuItem iMenuItem, @Nonnull String string, @Nonnull ISimpleURL iSimpleURL, @Nonnull IHasDisplayText iHasDisplayText) {
        return this.createItem(iMenuItem, string, (IHasSimpleURL)new ConstantHasSimpleURL(iSimpleURL), iHasDisplayText);
    }

    @Nonnull
    default public IMenuItemExternal createItem(@Nonnull IMenuItem iMenuItem, @Nonnull String string, @Nonnull IHasSimpleURL iHasSimpleURL, @Nonnull IHasDisplayText iHasDisplayText) {
        ValueEnforcer.notNull((Object)iMenuItem, (String)"Parent");
        return this.createItem((String)iMenuItem.getID(), string, iHasSimpleURL, iHasDisplayText);
    }

    @Nonnull
    default public IMenuItemExternal createItem(@Nonnull String string, @Nonnull String string2, @Nonnull ISimpleURL iSimpleURL, @Nonnull IHasDisplayText iHasDisplayText) {
        return this.createItem(string, string2, (IHasSimpleURL)new ConstantHasSimpleURL(iSimpleURL), iHasDisplayText);
    }

    @Nonnull
    public IMenuItemExternal createItem(@Nonnull String var1, @Nonnull String var2, @Nonnull IHasSimpleURL var3, @Nonnull IHasDisplayText var4);

    @Nonnull
    public IMenuItemRedirectToPage createRedirect(@Nonnull String var1, @Nonnull IMenuItemPage var2);

    public void setDefaultMenuItemID(@Nullable String var1);

    public void setDefaultMenuItemIDs(String ... var1);

    public void setDefaultMenuItemIDs(@Nullable Iterable<String> var1);

    @Nullable
    public String getDefaultMenuItemID();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllDefaultMenuItemIDs();

    @Nullable
    public IMenuItemPage getDefaultMenuItem();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMenuItemPage> getAllDefaultMenuItems();

    @Nullable
    public IMenuObject getMenuObjectOfID(@Nullable String var1);

    public void iterateAllMenuObjects(@Nonnull Consumer<? super IMenuObject> var1);

    @Nullable
    public IMenuItemPage replaceMenuItem(@Nonnull IPage var1);
}

