/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.menu;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.photon.core.menu.IMenuObject;
import com.helger.text.display.IHasDisplayText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.function.Predicate;

@FunctionalInterface
public interface IMenuObjectFilter
extends Predicate<IMenuObject>,
IHasDisplayText {
    @Nullable
    default public String getDisplayText(@Nonnull Locale locale) {
        return null;
    }

    @Nonnull
    default public IMenuObjectFilter and(final @Nonnull IMenuObjectFilter iMenuObjectFilter) {
        ValueEnforcer.notNull((Object)iMenuObjectFilter, (String)"Other");
        final IMenuObjectFilter iMenuObjectFilter2 = this;
        return new IMenuObjectFilter(){

            @Override
            public boolean test(IMenuObject iMenuObject) {
                return iMenuObjectFilter2.test(iMenuObject) && iMenuObjectFilter.test(iMenuObject);
            }

            @Override
            @Nullable
            public String getDisplayText(@Nonnull Locale locale) {
                return StringHelper.getConcatenatedOnDemand((String)iMenuObjectFilter2.getDisplayText(locale), (String)" + ", (String)iMenuObjectFilter.getDisplayText(locale));
            }
        };
    }

    @Nonnull
    default public IMenuObjectFilter or(final @Nonnull IMenuObjectFilter iMenuObjectFilter) {
        ValueEnforcer.notNull((Object)iMenuObjectFilter, (String)"Other");
        final IMenuObjectFilter iMenuObjectFilter2 = this;
        return new IMenuObjectFilter(){

            @Override
            public boolean test(IMenuObject iMenuObject) {
                return iMenuObjectFilter2.test(iMenuObject) || iMenuObjectFilter.test(iMenuObject);
            }

            @Override
            @Nullable
            public String getDisplayText(@Nonnull Locale locale) {
                return StringHelper.getNotNull((String)iMenuObjectFilter2.getDisplayText(locale), (String)iMenuObjectFilter.getDisplayText(locale));
            }
        };
    }
}

