/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.menu;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.trait.IGenericImplTrait;
import com.helger.photon.core.menu.IMenuObject;
import com.helger.photon.core.menu.IMenuObjectFilter;
import com.helger.typeconvert.collection.AttributeContainerAny;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public abstract class AbstractMenuObject<IMPLTYPE extends AbstractMenuObject<IMPLTYPE>>
implements IMenuObject,
IGenericImplTrait<IMPLTYPE> {
    private final String m_sID;
    private IMenuObjectFilter m_aDisplayFilter;
    private final AttributeContainerAny<String> m_aAttrs = new AttributeContainerAny();

    public AbstractMenuObject(@Nonnull @Nonempty String string) {
        this.m_sID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
    }

    @Nonnull
    @Nonempty
    public final String getID() {
        return this.m_sID;
    }

    @Nonnull
    public final IMPLTYPE setDisplayFilter(@Nullable IMenuObjectFilter iMenuObjectFilter) {
        this.m_aDisplayFilter = iMenuObjectFilter;
        return (IMPLTYPE)((AbstractMenuObject)this.thisAsT());
    }

    @Override
    @Nullable
    public final IMenuObjectFilter getDisplayFilter() {
        return this.m_aDisplayFilter;
    }

    @Override
    public final boolean matchesDisplayFilter() {
        return this.m_aDisplayFilter == null || this.m_aDisplayFilter.test(this);
    }

    @Nonnull
    @ReturnsMutableObject
    public final AttributeContainerAny<String> attrs() {
        return this.m_aAttrs;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractMenuObject abstractMenuObject = (AbstractMenuObject)object;
        return this.m_sID.equals(abstractMenuObject.m_sID);
    }

    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_sID).getHashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("ID", (Object)this.m_sID).appendIfNotNull("DisplayFilter", (Object)this.m_aDisplayFilter).append("Attrs", this.m_aAttrs).getToString();
    }
}

