/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.longrun;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.ICommonsList;
import com.helger.dao.DAOException;
import com.helger.dao.wal.AbstractMapBasedWALDAO;
import com.helger.photon.core.longrun.LongRunningJobData;
import com.helger.photon.io.dao.AbstractPhotonMapBasedWALDAO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@ThreadSafe
public class LongRunningJobResultManager
extends AbstractPhotonMapBasedWALDAO<LongRunningJobData, LongRunningJobData> {
    public LongRunningJobResultManager(@Nonnull @Nonempty String string) throws DAOException {
        super(LongRunningJobData.class, string, new AbstractMapBasedWALDAO.InitSettings().setOrderedMapSupplier());
    }

    public void addResult(@Nonnull LongRunningJobData longRunningJobData) {
        ValueEnforcer.notNull((Object)longRunningJobData, (String)"JobData");
        if (!longRunningJobData.isEnded()) {
            throw new IllegalArgumentException("Passed jobData is not yet finished");
        }
        this.m_aRWLock.writeLocked(() -> this.internalCreateItem(longRunningJobData));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<? extends LongRunningJobData> getAllJobResults() {
        return this.getAll();
    }

    @Nullable
    public LongRunningJobData getJobResultOfID(@Nullable String string) {
        return (LongRunningJobData)this.getOfID(string);
    }
}

