/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.longrun;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.rt.StackTraceHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.render.HCRenderer;
import com.helger.json.IJson;
import com.helger.json.serialize.JsonWriter;
import com.helger.photon.core.longrun.ELongRunningJobResultType;
import com.helger.url.ISimpleURL;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.serialize.MicroWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;

@Immutable
public class LongRunningJobResult {
    private final ELongRunningJobResultType m_eType;
    private final Object m_aResult;

    protected LongRunningJobResult(@Nonnull ELongRunningJobResultType eLongRunningJobResultType, @Nonnull Object object) {
        ValueEnforcer.notNull((Object)((Object)eLongRunningJobResultType), (String)"Type");
        ValueEnforcer.notNull((Object)object, (String)"Result");
        this.m_eType = eLongRunningJobResultType;
        this.m_aResult = object;
    }

    @Nonnull
    public final ELongRunningJobResultType getType() {
        return this.m_eType;
    }

    @Nonnull
    public final Object getResultObject() {
        return this.m_aResult;
    }

    @Nullable
    public File getResultFile() {
        return this.getType().equals((Object)ELongRunningJobResultType.FILE) ? (File)this.m_aResult : null;
    }

    @Nullable
    public IMicroNode getResultXML() {
        return this.getType().equals((Object)ELongRunningJobResultType.XML) ? (IMicroNode)this.m_aResult : null;
    }

    @Nullable
    public String getResultText() {
        return this.getType().equals((Object)ELongRunningJobResultType.TEXT) ? (String)this.m_aResult : null;
    }

    @Nullable
    public ISimpleURL getResultLink() {
        return this.getType().equals((Object)ELongRunningJobResultType.LINK) ? (ISimpleURL)this.m_aResult : null;
    }

    @Nullable
    public IJson getResultJson() {
        return this.getType().equals((Object)ELongRunningJobResultType.JSON) ? (IJson)this.m_aResult : null;
    }

    @Nonnull
    public String getAsString() {
        switch (this.m_eType) {
            case FILE: {
                return this.getResultFile().getAbsolutePath();
            }
            case XML: {
                return MicroWriter.getNodeAsString((IMicroNode)this.getResultXML());
            }
            case TEXT: {
                return this.getResultText();
            }
            case LINK: {
                return this.getResultLink().getAsString();
            }
            case JSON: {
                return new JsonWriter().writeAsString(this.getResultJson());
            }
        }
        throw new IllegalStateException("Unhandled type: " + String.valueOf((Object)this.m_eType));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Type", (Enum)this.m_eType).append("Result", this.m_aResult).getToString();
    }

    @Nonnull
    public static LongRunningJobResult createFile(@Nonnull File file) {
        return new LongRunningJobResult(ELongRunningJobResultType.FILE, file);
    }

    @Nonnull
    public static LongRunningJobResult createXML(@Nonnull IMicroNode iMicroNode) {
        return new LongRunningJobResult(ELongRunningJobResultType.XML, iMicroNode);
    }

    @Nonnull
    public static LongRunningJobResult createXML(@Nonnull IHCNode iHCNode) {
        return LongRunningJobResult.createXML(HCRenderer.getAsNode((IHCNode)iHCNode));
    }

    @Nonnull
    public static LongRunningJobResult createText(@Nonnull String string) {
        return new LongRunningJobResult(ELongRunningJobResultType.TEXT, string);
    }

    @Nonnull
    public static LongRunningJobResult createExceptionText(@Nonnull Throwable throwable) {
        return LongRunningJobResult.createText(throwable.getClass().getName() + " -  " + throwable.getMessage() + "\n" + StackTraceHelper.getStackAsString((Throwable)throwable));
    }

    @Nonnull
    public static LongRunningJobResult createLink(@Nonnull ISimpleURL iSimpleURL) {
        return new LongRunningJobResult(ELongRunningJobResultType.LINK, iSimpleURL);
    }

    @Nonnull
    public static LongRunningJobResult createJson(@Nonnull IJson iJson) {
        return new LongRunningJobResult(ELongRunningJobResultType.JSON, iJson);
    }
}

