/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.longrun;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.base.state.ESuccess;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsCollection;
import com.helger.collection.commons.ICommonsMap;
import com.helger.photon.core.longrun.ILongRunningJob;
import com.helger.photon.core.longrun.LongRunningJobData;
import com.helger.photon.core.longrun.LongRunningJobResult;
import com.helger.photon.core.longrun.LongRunningJobResultManager;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class LongRunningJobManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LongRunningJobManager.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, LongRunningJobData> m_aRunningJobs = new CommonsHashMap();
    private final LongRunningJobResultManager m_aResultMgr;

    public LongRunningJobManager(@Nonnull LongRunningJobResultManager longRunningJobResultManager) {
        this.m_aResultMgr = (LongRunningJobResultManager)((Object)ValueEnforcer.notNull((Object)((Object)longRunningJobResultManager), (String)"ResultMgr"));
    }

    @Nonnull
    @Nonempty
    public String onStartJob(@Nonnull ILongRunningJob iLongRunningJob, @Nullable String string) {
        ValueEnforcer.notNull((Object)iLongRunningJob, (String)"Job");
        String string2 = GlobalIDFactory.getNewStringID();
        LongRunningJobData longRunningJobData = new LongRunningJobData(string2, iLongRunningJob.getJobDescription(), string);
        this.m_aRWLock.writeLocked(() -> this.m_aRunningJobs.put((Object)string2, (Object)longRunningJobData));
        return string2;
    }

    public void onEndJob(@Nullable String string, @Nonnull ESuccess eSuccess, @Nonnull LongRunningJobResult longRunningJobResult) {
        ValueEnforcer.notNull((Object)eSuccess, (String)"ExecSuccess");
        ValueEnforcer.notNull((Object)longRunningJobResult, (String)"Result");
        LongRunningJobData longRunningJobData = (LongRunningJobData)this.m_aRWLock.writeLockedGet(() -> {
            LongRunningJobData longRunningJobData = (LongRunningJobData)this.m_aRunningJobs.remove((Object)string);
            if (longRunningJobData == null) {
                throw new IllegalArgumentException("Illegal job ID '" + string + "' passed!");
            }
            longRunningJobData.onJobEnd(eSuccess, longRunningJobResult);
            return longRunningJobData;
        });
        this.m_aResultMgr.addResult(longRunningJobData);
    }

    @Nonnegative
    public int getRunningJobCount() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aRunningJobs.size());
    }

    @Nonnull
    @Nonempty
    public ICommonsCollection<LongRunningJobData> getAllRunningJobs() {
        return (ICommonsCollection)this.m_aRWLock.readLockedGet(() -> this.m_aRunningJobs.copyOfValues());
    }

    public void waitUntilAllJobsAreFinished() throws InterruptedException {
        int n;
        int n2 = 1;
        while ((n = this.getRunningJobCount()) != 0) {
            LOGGER.error("There are still " + n + " long running jobs in the background! Waiting for them to finish...");
            Thread.sleep((long)n2 * 1000L);
            if (n2 >= 10) continue;
            ++n2;
        }
    }
}

