/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.longrun;

import com.helger.base.state.ETriState;
import com.helger.json.serialize.JsonReader;
import com.helger.photon.core.longrun.ELongRunningJobResultType;
import com.helger.photon.core.longrun.LongRunningJobData;
import com.helger.photon.core.longrun.LongRunningJobResult;
import com.helger.text.IMultilingualText;
import com.helger.text.ReadOnlyMultilingualText;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import com.helger.xml.microdom.serialize.MicroReader;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.time.LocalDateTime;

public final class LongRunningJobDataMicroTypeConverter
implements IMicroTypeConverter<LongRunningJobData> {
    private static final String ATTR_ID = "id";
    private static final String ATTR_STARTDT = "startdt";
    private static final String ATTR_ENDDT = "enddt";
    private static final String ATTR_EXECSUCCESS = "execsuccess";
    private static final String ATTR_STARTINGUSERID = "startinguserid";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_RESULT = "result";
    private static final String ATTR_TYPE = "type";

    @Nullable
    public IMicroElement convertToMicroElement(@Nonnull LongRunningJobData longRunningJobData, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_ID, longRunningJobData.getID());
        microElement.addChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)longRunningJobData.getJobDescription(), (String)string, (String)ELEMENT_DESCRIPTION));
        microElement.setAttributeWithConversion(ATTR_STARTDT, (Object)longRunningJobData.getStartDateTime());
        microElement.setAttribute(ATTR_STARTINGUSERID, longRunningJobData.getStartingUserID());
        microElement.setAttributeWithConversion(ATTR_ENDDT, (Object)longRunningJobData.getEndDateTime());
        microElement.setAttribute(ATTR_EXECSUCCESS, longRunningJobData.getExecutionSuccess().getID());
        IMicroElement iMicroElement = microElement.addElementNS(string, ELEMENT_RESULT);
        iMicroElement.setAttribute(ATTR_TYPE, longRunningJobData.getResult().getType().getID());
        iMicroElement.addText((CharSequence)longRunningJobData.getResult().getAsString());
        return microElement;
    }

    @Nullable
    public LongRunningJobData convertToNative(@Nonnull IMicroElement iMicroElement) {
        String string = iMicroElement.getAttributeValue(ATTR_ID);
        IMultilingualText iMultilingualText = (IMultilingualText)MicroTypeConverter.convertToNative((IMicroElement)iMicroElement.getFirstChildElement(ELEMENT_DESCRIPTION), ReadOnlyMultilingualText.class);
        LocalDateTime localDateTime = (LocalDateTime)iMicroElement.getAttributeValueWithConversion(ATTR_STARTDT, LocalDateTime.class);
        String string2 = iMicroElement.getAttributeValue(ATTR_STARTINGUSERID);
        LocalDateTime localDateTime2 = (LocalDateTime)iMicroElement.getAttributeValueWithConversion(ATTR_ENDDT, LocalDateTime.class);
        ETriState eTriState = ETriState.getFromIDOrUndefined((String)iMicroElement.getAttributeValue(ATTR_EXECSUCCESS));
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(ELEMENT_RESULT);
        ELongRunningJobResultType eLongRunningJobResultType = ELongRunningJobResultType.getFromIDOrNull(iMicroElement2.getAttributeValue(ATTR_TYPE));
        String string3 = iMicroElement2.getTextContent();
        return new LongRunningJobData(string, localDateTime, localDateTime2, eTriState, string2, iMultilingualText, switch (eLongRunningJobResultType) {
            case ELongRunningJobResultType.FILE -> LongRunningJobResult.createFile(new File(string3));
            case ELongRunningJobResultType.XML -> LongRunningJobResult.createXML((IMicroNode)MicroReader.readMicroXML((String)string3));
            case ELongRunningJobResultType.TEXT -> LongRunningJobResult.createText(string3);
            case ELongRunningJobResultType.LINK -> LongRunningJobResult.createLink((ISimpleURL)new SimpleURL(string3));
            case ELongRunningJobResultType.JSON -> LongRunningJobResult.createJson(JsonReader.readFromString((String)string3));
            default -> throw new IllegalStateException("Unknown type: " + String.valueOf((Object)eLongRunningJobResultType));
        });
    }
}

