/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.longrun;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.IHasID;
import com.helger.base.state.ESuccess;
import com.helger.base.state.ETriState;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.datetime.helper.PDTFactory;
import com.helger.photon.core.longrun.LongRunningJobResult;
import com.helger.text.IMultilingualText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;

@NotThreadSafe
public final class LongRunningJobData
implements IHasID<String>,
Serializable {
    private final String m_sID;
    private final IMultilingualText m_aJobDescription;
    private final LocalDateTime m_aStartDateTime;
    private final String m_sStartingUserID;
    private LocalDateTime m_aEndDateTime;
    private ETriState m_eExecSuccess;
    private LongRunningJobResult m_aResult;

    public LongRunningJobData(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable String string2) {
        this.m_sID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"JobID");
        this.m_aJobDescription = (IMultilingualText)ValueEnforcer.notNull((Object)iMultilingualText, (String)"JobDescription");
        this.m_aStartDateTime = PDTFactory.getCurrentLocalDateTime();
        this.m_sStartingUserID = string2;
        this.m_eExecSuccess = ETriState.UNDEFINED;
    }

    LongRunningJobData(@Nonnull @Nonempty String string, @Nonnull LocalDateTime localDateTime, @Nonnull LocalDateTime localDateTime2, @Nonnull ETriState eTriState, @Nullable String string2, @Nonnull IMultilingualText iMultilingualText, @Nonnull LongRunningJobResult longRunningJobResult) {
        this.m_sID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
        this.m_aStartDateTime = (LocalDateTime)ValueEnforcer.notNull((Object)localDateTime, (String)"StartDateTime");
        this.m_aEndDateTime = (LocalDateTime)ValueEnforcer.notNull((Object)localDateTime2, (String)"EndDateTime");
        this.m_eExecSuccess = (ETriState)ValueEnforcer.notNull((Object)eTriState, (String)"ExecSuccess");
        this.m_sStartingUserID = string2;
        this.m_aJobDescription = (IMultilingualText)ValueEnforcer.notNull((Object)iMultilingualText, (String)"JobDescription");
        this.m_aResult = (LongRunningJobResult)ValueEnforcer.notNull((Object)longRunningJobResult, (String)"Result");
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    public IMultilingualText getJobDescription() {
        return this.m_aJobDescription;
    }

    @Nonnull
    public LocalDateTime getStartDateTime() {
        return this.m_aStartDateTime;
    }

    @Nullable
    public String getStartingUserID() {
        return this.m_sStartingUserID;
    }

    void onJobEnd(@Nonnull ESuccess eSuccess, @Nonnull LongRunningJobResult longRunningJobResult) {
        ValueEnforcer.notNull((Object)eSuccess, (String)"ExecSuccess");
        ValueEnforcer.notNull((Object)longRunningJobResult, (String)"Result");
        if (this.isEnded()) {
            throw new IllegalStateException("Job was already ended");
        }
        this.m_aEndDateTime = PDTFactory.getCurrentLocalDateTime();
        this.m_eExecSuccess = ETriState.valueOf((boolean)eSuccess.isSuccess());
        this.m_aResult = longRunningJobResult;
        if (this.m_aResult == null) {
            throw new IllegalStateException("Failed to create job results object!");
        }
    }

    public boolean isEnded() {
        return this.m_aEndDateTime != null;
    }

    @Nullable
    public LocalDateTime getEndDateTime() {
        return this.m_aEndDateTime;
    }

    @Nonnull
    public Duration getDuration() {
        if (!this.isEnded()) {
            throw new IllegalStateException("Job is still running!");
        }
        return Duration.between(this.m_aStartDateTime, this.getEndDateTime());
    }

    @Nonnull
    public ETriState getExecutionSuccess() {
        return this.m_eExecSuccess;
    }

    @Nullable
    public LongRunningJobResult getResult() {
        return this.m_aResult;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).append("jobDescription", (Object)this.m_aJobDescription).append("startDateTime", (Object)this.m_aStartDateTime).append("startingUserID", (Object)this.m_sStartingUserID).append("endDateTime", (Object)this.m_aEndDateTime).append("execSucces", (Enum)this.m_eExecSuccess).append("result", (Object)this.m_aResult).getToString();
    }
}

