/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.longrun;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ESuccess;
import com.helger.photon.core.longrun.ILongRunningJob;
import com.helger.photon.core.longrun.LongRunningJobManager;
import com.helger.photon.core.longrun.LongRunningJobResult;
import com.helger.photon.core.mgr.PhotonBasicManager;
import com.helger.photon.security.login.LoggedInUserManager;
import com.helger.text.IMultilingualText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLongRunningJobRunnable
implements Runnable,
ILongRunningJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLongRunningJobRunnable.class);
    private final String m_sJobID;
    private final IMultilingualText m_aDesc;

    public AbstractLongRunningJobRunnable(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"JobID");
        ValueEnforcer.notNull((Object)iMultilingualText, (String)"JobDesc");
        this.m_sJobID = string;
        this.m_aDesc = iMultilingualText;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getJobID() {
        return this.m_sJobID;
    }

    @Override
    @Nonnull
    public final IMultilingualText getJobDescription() {
        return this.m_aDesc;
    }

    @Nullable
    @OverrideOnDemand
    protected String getCurrentUserID() {
        return LoggedInUserManager.getInstance().getCurrentUserID();
    }

    @Nonnull
    protected static final LongRunningJobManager getLongRunningJobManager() {
        return PhotonBasicManager.getLongRunningJobMgr();
    }

    @Override
    public void run() {
        String string = this.getCurrentUserID();
        String string2 = AbstractLongRunningJobRunnable.getLongRunningJobManager().onStartJob(this, string);
        LOGGER.info("Starting long running job '" + this.m_sJobID + "' as user '" + string + "' with unique ID '" + string2 + "'");
        try {
            LongRunningJobResult longRunningJobResult = this.createLongRunningJobResult();
            AbstractLongRunningJobRunnable.getLongRunningJobManager().onEndJob(string2, ESuccess.SUCCESS, longRunningJobResult);
            LOGGER.info("Finished long running job '" + string2 + "' with success and result of type " + String.valueOf((Object)longRunningJobResult.getType()));
        }
        catch (Exception exception) {
            AbstractLongRunningJobRunnable.getLongRunningJobManager().onEndJob(string2, ESuccess.FAILURE, LongRunningJobResult.createExceptionText(exception));
            LOGGER.info("Error executing long running job '" + string2 + "'", (Throwable)exception);
        }
    }
}

