/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.login;

import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.ThreadHelper;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EContinue;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsSet;
import com.helger.photon.app.html.IHTMLProvider;
import com.helger.photon.app.html.PhotonHTMLHelper;
import com.helger.photon.security.login.ELoginResult;
import com.helger.photon.security.login.LoggedInUserManager;
import com.helger.photon.security.login.LoginInfo;
import com.helger.photon.security.mgr.PhotonSecurityManager;
import com.helger.photon.security.user.IUser;
import com.helger.security.authentication.credentials.ICredentialValidationResult;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoginManager {
    public static final String LOGIN_INFO_REMOTE_ADDRESS = "remote-address";
    public static final String LOGIN_INFO_REMOTE_HOST = "remote-host";
    public static final String LOGIN_INFO_REQUEST_URI = "request-uri";
    public static final String LOGIN_INFO_QUERY_STRING = "query-string";
    public static final String LOGIN_INFO_REQUEST_COUNT = "request-count";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLoginManager.class);
    private ICommonsSet<String> m_aRequiredRoleIDs;
    private Duration m_aFailedLoginWaitTime = Duration.ZERO;

    protected AbstractLoginManager() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsSet<String> getAllRequiredRoles() {
        return new CommonsHashSet(this.m_aRequiredRoleIDs);
    }

    public final void setRequiredRoleIDs(@Nullable Collection<String> collection) {
        this.m_aRequiredRoleIDs = collection == null ? null : new CommonsHashSet(collection);
    }

    @Nonnull
    public final Duration getFailedLoginWaitingTime() {
        return this.m_aFailedLoginWaitTime;
    }

    public final void setFailedLoginWaitingTime(@Nonnull Duration duration) {
        ValueEnforcer.notNull((Object)duration, (String)"FailedLoginWaitTime");
        this.m_aFailedLoginWaitTime = duration;
    }

    @OverrideOnDemand
    protected abstract IHTMLProvider createLoginScreen(boolean var1, @Nonnull ICredentialValidationResult var2);

    @OverrideOnDemand
    protected boolean isLoginInProgress(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        return "validate-login-credentials".equals(iRequestWebScopeWithoutResponse.params().getAsString((Object)"login-action"));
    }

    @Nullable
    @OverrideOnDemand
    protected String getLoginName(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        return iRequestWebScopeWithoutResponse.params().getAsString((Object)"userid");
    }

    @Nullable
    @OverrideOnDemand
    protected String getPassword(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        return iRequestWebScopeWithoutResponse.params().getAsString((Object)"password");
    }

    @Nullable
    @OverrideOnDemand
    protected IUser getUserOfLoginName(@Nullable String string) {
        return PhotonSecurityManager.getUserMgr().getUserOfLoginName(string);
    }

    @OverrideOnDemand
    protected void modifyLoginInfo(@Nonnull LoginInfo loginInfo, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, boolean bl) {
        loginInfo.attrs().putIn((Object)LOGIN_INFO_REMOTE_ADDRESS, (Object)iRequestWebScopeWithoutResponse.getRemoteAddr());
        loginInfo.attrs().putIn((Object)LOGIN_INFO_REMOTE_HOST, (Object)iRequestWebScopeWithoutResponse.getRemoteHost());
        loginInfo.attrs().putIn((Object)LOGIN_INFO_REQUEST_URI, (Object)iRequestWebScopeWithoutResponse.getRequestURIEncoded());
        loginInfo.attrs().putIn((Object)LOGIN_INFO_QUERY_STRING, (Object)iRequestWebScopeWithoutResponse.getQueryString());
        loginInfo.attrs().putIn((Object)LOGIN_INFO_REQUEST_COUNT, (Object)Integer.toString(loginInfo.attrs().getAsInt((Object)LOGIN_INFO_REQUEST_COUNT, 0) + 1));
    }

    @OverrideOnDemand
    protected String getPostLoginRedirectURL(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        return iRequestWebScopeWithoutResponse.getURLEncoded();
    }

    @Nonnull
    public final EContinue checkUserAndShowLogin(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) {
        LoginInfo loginInfo;
        Object object;
        LoggedInUserManager loggedInUserManager = LoggedInUserManager.getInstance();
        String string = loggedInUserManager.getCurrentUserID();
        boolean bl = false;
        if (string == null) {
            String string2;
            boolean bl2 = false;
            object = ELoginResult.SUCCESS;
            if (this.isLoginInProgress(iRequestWebScopeWithoutResponse)) {
                string2 = this.getLoginName(iRequestWebScopeWithoutResponse);
                String string3 = this.getPassword(iRequestWebScopeWithoutResponse);
                IUser iUser = this.getUserOfLoginName(string2);
                object = loggedInUserManager.loginUser(iUser, string3, this.m_aRequiredRoleIDs);
                if (object.isSuccess()) {
                    string = (String)iUser.getID();
                    bl = true;
                } else {
                    if (GlobalDebug.isDebugMode()) {
                        LOGGER.warn("Login of '" + string2 + "' failed because " + String.valueOf(object));
                    }
                    boolean bl3 = bl2 = StringHelper.isNotEmpty((String)string2) || StringHelper.isNotEmpty((String)string3);
                    if (iUser != null && this.m_aFailedLoginWaitTime.compareTo(Duration.ZERO) > 0) {
                        long l = Math.max((long)iUser.getConsecutiveFailedLoginCount(), 1L);
                        Duration duration = this.m_aFailedLoginWaitTime.multipliedBy(l);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Now waiting " + String.valueOf(duration) + " because of a failed login");
                        }
                        ThreadHelper.sleep((Duration)duration);
                    }
                }
            }
            if (string == null) {
                string2 = this.createLoginScreen(bl2, (ICredentialValidationResult)object);
                PhotonHTMLHelper.createHTMLResponse((IRequestWebScopeWithoutResponse)iRequestWebScopeWithoutResponse, (UnifiedResponse)unifiedResponse, (IHTMLProvider)string2);
            }
        }
        if ((loginInfo = loggedInUserManager.getLoginInfo(string)) != null) {
            loginInfo.setLastAccessDTNow();
            this.modifyLoginInfo(loginInfo, iRequestWebScopeWithoutResponse, bl);
        } else if (string != null) {
            LOGGER.error("Failed to resolve LoginInfo of user ID '" + string + "'");
        }
        if (bl) {
            object = this.getPostLoginRedirectURL(iRequestWebScopeWithoutResponse);
            LOGGER.info("Redirecting user after login to '" + (String)object + "'");
            unifiedResponse.setRedirect((String)object);
            return EContinue.BREAK;
        }
        return EContinue.valueOf((string != null ? 1 : 0) != 0);
    }
}

