/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.locale;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.photon.core.locale.ILocaleManager;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

@NotThreadSafe
public class LocaleManager
implements ILocaleManager {
    private final ICommonsOrderedSet<Locale> m_aLocales = new CommonsLinkedHashSet();
    private Locale m_aDefaultLocale;

    @Override
    @Nonnull
    public EChange registerLocale(@Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"Locale");
        if (!this.m_aLocales.add((Object)locale)) {
            return EChange.UNCHANGED;
        }
        if (this.m_aLocales.size() == 1) {
            this.setDefaultLocale(locale);
        }
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange setDefaultLocale(@Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"DefaultLocale");
        ValueEnforcer.isTrue((boolean)this.m_aLocales.contains((Object)locale), () -> "The supposed default locale " + String.valueOf(locale) + " is not a valid application locale! It needs to be registered before it can be set as a default.");
        if (locale.equals(this.m_aDefaultLocale)) {
            return EChange.UNCHANGED;
        }
        this.m_aDefaultLocale = locale;
        return EChange.UNCHANGED;
    }

    @Override
    @Nullable
    public Locale getDefaultLocale() {
        return this.m_aDefaultLocale;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Locale> getAllAvailableLocales() {
        return this.m_aLocales.getCopyAsList();
    }

    @Override
    public boolean hasLocales() {
        return this.m_aLocales.isNotEmpty();
    }

    @Override
    public boolean isSupportedLocale(@Nullable Locale locale) {
        return this.m_aLocales.contains((Object)locale);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Locales", this.m_aLocales).append("DefaultLocale", (Object)this.m_aDefaultLocale).getToString();
    }
}

