/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.locale;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.UsedViaReflection;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsList;
import com.helger.photon.core.locale.ILocaleManager;
import com.helger.photon.core.locale.LocaleManager;
import com.helger.web.scope.singleton.AbstractGlobalWebSingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

@NotThreadSafe
public final class GlobalLocaleManager
extends AbstractGlobalWebSingleton
implements ILocaleManager {
    private final LocaleManager m_aInstance = new LocaleManager();

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public GlobalLocaleManager() {
    }

    @Nonnull
    public static GlobalLocaleManager getInstance() {
        return (GlobalLocaleManager)GlobalLocaleManager.getGlobalSingleton(GlobalLocaleManager.class);
    }

    @Override
    @Nonnull
    public EChange registerLocale(@Nonnull Locale locale) {
        return this.m_aInstance.registerLocale(locale);
    }

    @Override
    @Nonnull
    public EChange setDefaultLocale(@Nonnull Locale locale) {
        return this.m_aInstance.setDefaultLocale(locale);
    }

    @Override
    @Nullable
    public Locale getDefaultLocale() {
        return this.m_aInstance.getDefaultLocale();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Locale> getAllAvailableLocales() {
        return this.m_aInstance.getAllAvailableLocales();
    }

    @Override
    public boolean hasLocales() {
        return this.m_aInstance.hasLocales();
    }

    @Override
    public boolean isSupportedLocale(@Nullable Locale locale) {
        return this.m_aInstance.isSupportedLocale(locale);
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Instance", (Object)this.m_aInstance).getToString();
    }
}

