/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.job.smtp;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.photon.core.mgr.PhotonCoreManager;
import com.helger.quartz.DisallowConcurrentExecution;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IScheduleBuilder;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobExecutionException;
import com.helger.quartz.SimpleScheduleBuilder;
import com.helger.quartz.TriggerKey;
import com.helger.schedule.quartz.GlobalQuartzScheduler;
import com.helger.schedule.quartz.trigger.JDK8TriggerBuilder;
import com.helger.smtp.failed.FailedMailData;
import com.helger.smtp.scope.ScopedMailAPI;
import com.helger.web.scope.util.AbstractScopeAwareJob;
import jakarta.annotation.Nonnull;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
public final class FailedMailResendJob
extends AbstractScopeAwareJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(FailedMailResendJob.class);

    protected void onExecute(@Nonnull JobDataMap jobDataMap, @Nonnull IJobExecutionContext iJobExecutionContext) throws JobExecutionException {
        ICommonsList<FailedMailData> iCommonsList = PhotonCoreManager.getFailedMailQueue().removeAll();
        if (!iCommonsList.isEmpty()) {
            LOGGER.info("Resending " + iCommonsList.size() + " failed mails!");
            for (FailedMailData failedMailData : iCommonsList) {
                ScopedMailAPI.getInstance().queueMail(failedMailData.getSMTPSettings(), failedMailData.getEmailData());
            }
        }
    }

    @Nonnull
    public static TriggerKey schedule(@Nonnull SimpleScheduleBuilder simpleScheduleBuilder) {
        ValueEnforcer.notNull((Object)simpleScheduleBuilder, (String)"ScheduleBuilder");
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        return GlobalQuartzScheduler.getInstance().scheduleJob(FailedMailResendJob.class.getName(), JDK8TriggerBuilder.newTrigger().startNow().withSchedule((IScheduleBuilder)simpleScheduleBuilder), FailedMailResendJob.class, (Map)commonsHashMap);
    }
}

