/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.job.longrun;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.base.state.ESuccess;
import com.helger.photon.core.longrun.ILongRunningJob;
import com.helger.photon.core.longrun.LongRunningJobManager;
import com.helger.photon.core.longrun.LongRunningJobResult;
import com.helger.photon.core.mgr.PhotonBasicManager;
import com.helger.quartz.IJob;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.JobDataMap;
import com.helger.schedule.job.AbstractJob;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLongRunningJob
extends AbstractJob
implements ILongRunningJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLongRunningJob.class);
    private static final String KEY_LONG_RUNNING_JOB_ID = "$ph-longrunning.job.id";

    @Nullable
    protected abstract String getCurrentUserID(@Nonnull JobDataMap var1);

    @Nonnull
    protected static final LongRunningJobManager getLongRunningJobManager() {
        return PhotonBasicManager.getLongRunningJobMgr();
    }

    @OverridingMethodsMustInvokeSuper
    protected void beforeExecute(@Nonnull JobDataMap jobDataMap, @Nonnull IJobExecutionContext iJobExecutionContext) {
        String string = this.getCurrentUserID(jobDataMap);
        String string2 = AbstractLongRunningJob.getLongRunningJobManager().onStartJob(this, string);
        jobDataMap.put((Object)KEY_LONG_RUNNING_JOB_ID, (Object)string2);
        super.beforeExecute(jobDataMap, iJobExecutionContext);
    }

    @OverridingMethodsMustInvokeSuper
    protected void afterExecute(@Nonnull JobDataMap jobDataMap, @Nonnull IJobExecutionContext iJobExecutionContext, @Nonnull ESuccess eSuccess) {
        String string = jobDataMap.getAsString((Object)KEY_LONG_RUNNING_JOB_ID);
        try {
            if (string != null) {
                LongRunningJobResult longRunningJobResult = this.createLongRunningJobResult();
                AbstractLongRunningJob.getLongRunningJobManager().onEndJob(string, ESuccess.SUCCESS, longRunningJobResult);
            } else {
                LOGGER.error("Failed to retrieve long running job ID from JobDataMap " + String.valueOf(jobDataMap));
            }
        }
        catch (Exception exception) {
            LOGGER.error("Failed to end long running job", (Throwable)exception);
            AbstractLongRunningJob.triggerCustomExceptionHandler((Throwable)exception, (String)this.getClass().getName(), (IJob)this);
            AbstractLongRunningJob.getLongRunningJobManager().onEndJob(string, ESuccess.FAILURE, LongRunningJobResult.createExceptionText(exception));
        }
        super.afterExecute(jobDataMap, iJobExecutionContext, eSuccess);
    }
}

